% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLWS.R
\name{MLWS}
\alias{MLWS}
\title{MLWS test for multivariate spurious long memory.}
\usage{
MLWS(X, m, epsilon = c(0.02, 0.05), coint.elements = NULL, B = NULL,
  prewhite = c("none", "uni", "multi"), eta = rep(1/sqrt(min(dim(X))),
  min(dim(X))), rep = FALSE, approx = 100, split = 1,
  T_limdist = 1000, M_limdist = 5000)
}
\arguments{
\item{X}{data matrix}

\item{m}{bandwith parameter specifying the number of Fourier frequencies used 
for the estimation usually \code{floor(1+T^delta)}, where 0.5<delta<0.8 for consistency.}

\item{epsilon}{trimming parameter \code{epsilon=0.05} by default. Determines
minimum number of Fourier frequencies used in test statistic. For T>500 it is recommended 
to use \code{epsilon=0.02}. Confer Sibbertsen, Leschinski, Holzhausen (2018) for further details.}

\item{coint.elements}{Vector specifying which elements in the vector series are in a cointegrating relationship. By default \code{NULL}. Cf details.}

\item{B}{cointegrating matrix, if known. Default is \code{B=NULL}.}

\item{prewhite}{specifies the form of pre-whitening applied. One of \code{c("none","uni","multi")}. 
If \code{uni} is selected the univariate a univariate of maximal order (1,d,1) is selected using the AIC. 
If \code{multi} is selected \code{VARFIMA_est} is used to fit a VARFIMA(1,d,1) in final equations form.
Default is \code{none}.}

\item{eta}{vector of weights. Default is \code{rep(1/sqrt(min(dim(X))),min(dim(X)))}.}

\item{rep}{if \code{prewhite="multi"} is selected, rep specifies whether the current parameter values are 
displayed to the user during optimization procedure. Default is \code{rep=FALSE}.}

\item{approx}{if \code{prewhite="multi"} is selected, approx specifies the order of the AR-approximation
used in \code{VARFIMA_est}. Default is \code{approx=100}.}

\item{split}{if \code{prewhite="multi"} is selected, \code{split} whether the sample should be split into
subsamples to speed up the estimation. Default is \code{split=1}, so that the whole sample is used.}

\item{T_limdist}{number of increments used in simulation if limit distribution. 
Only relevant for component-wise version of the test. Default is \code{T_limdist=1000}.}

\item{M_limdist}{number of replications for simulation of the limit distribution.
Default is \code{M_limdist=5000}.}
}
\description{
Multivariate local Whittle Score type test for the null hypothesis of true long
             memory against the alternative of spurious long memory suggested by Sibbertsen, 
             Leschinski and Holzhausen (2018).
}
\examples{
T<-500
m<-floor(1+T^0.75)
series<-FI.sim(T=T,q=2,rho=0.7,d=c(0.4,0.2))
ts.plot(series, col=1:2)
MLWS(X=series, m=m, epsilon=0.05)

shift.series<-series+ARRLS.sim(T=T, phi=0, sig.shift=2, prob=5/T)
ts.plot(shift.series, col=1:2)
MLWS(X=shift.series, m=m, epsilon=0.05)

T<-500
m<-floor(T^0.75)
series<-FI.sim(T=T,q=2,rho=0,d=c(0.1,0.4), B=rbind(c(1,-1),c(0,1)))
ts.plot(series, col=1:2)
MLWS(series, m=m)
MLWS(series, m=m, coint.elements=c(1,2))
}
\references{
Sibbertsen, P., Leschinski, C. H., Holzhausen, M., (2018): A Multivariate Test 
             Against Spurious Long Memory. Journal of Econometrics, Vol. 203, No. 1, pp. 33 - 49.
}
