% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDLS.R
\name{F.hat}
\alias{F.hat}
\title{Empirical cummulative spectral distribution function}
\usage{
F.hat(X, Y, k, l)
}
\arguments{
\item{X}{data matrix.}

\item{Y}{data matrix.}

\item{k}{integer that determines the order number of the first Fourier frequency used.}

\item{l}{integer that determines the order number of the last Fourier frequency used.}
}
\description{
Calculates the empirical cummulative spectral distribution function from the 
cross periodogram of the vector valued time series X and Y.
}
\examples{
T<-500
d<-c(0.4, 0.2, 0.3)

data<-FI.sim(T, q=3, rho=0, d=d)
X<-data[,1:2]
Y<-data[,3]
F.hat(X, Y, 1, floor(T/2))
}
