% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ising.R
\name{ising}
\alias{ising}
\title{Linearized Bregman solver for composite conditionally likelihood of Ising model 
 with lasso penalty.}
\usage{
ising(X, kappa, alpha, c = 4, tlist, nt = 100, trate = 100,
  intercept = TRUE)
}
\arguments{
\item{X}{An n-by-p matrix of variables.}

\item{kappa}{The damping factor of the Linearized Bregman Algorithm that is
defined in the reference paper. See details.}

\item{alpha}{Parameter in Linearized Bregman algorithm which controls the 
step-length of the discretized solver for the Bregman Inverse Scale Space. 
See details.}

\item{c}{Normalized step-length. If alpha is missing, alpha is automatically generated by 
\code{alpha=c*n*p/(kappa*||X^T*X||_2)}. Default is 4. It should be in (0,4).
If beyond this range the path may be oscillated at large t values.}

\item{tlist}{Parameters t along the path.}

\item{nt}{Number of t. Used only if tlist is missing. Default is 100.}

\item{trate}{tmax/tmin. Used only if tlist is missing. Default is 100.}

\item{intercept}{if TRUE, an intercept is included in the model (and not 
penalized), otherwise no intercept is included. Default is TRUE.}
}
\value{
A "ising" class object is returned. The list contains the call, 
 the path, the intercept term a0 and value for alpha, kappa, t.
}
\description{
Solver for the entire solution path of coefficients.
}
\details{
The data matrix X is assumed in \{1,-1\}. The Ising model here used is described as following:\cr
\deqn{P(x) \sim \exp(\sum_i \frac{a_{0i}}{2}1(x_i=1) + x^T \Theta x/4)}\cr
where \eqn{\Theta} is p-by-p symmetric and 0 on diagnal. Then conditional on \eqn{x_{-j}}\cr
\deqn{\frac{P(x_j=1)}{P(x_j=-1)} = exp(\sum_i a_{0i} + \sum_{i\neq j}\theta_{ji}x_i)}\cr
then the composite conditional likelihood is like this:\cr
\deqn{- \frac{1}{p}\sum_{j} condloglik(X_j | X_{-j})}
}
\examples{
require(animation)
X = matrix(2*(as.numeric(rnorm(200*10))>0)-1,200,10)
obj = ising(X,10,nt=100,trate=10)
ncol = 50
breaks = seq(min(obj$path),max(obj$path),length.out=ncol+1)
saveGIF({
for (i in (1:20)*5) image(obj$path[,,i],col=rainbow(ncol),breaks=breaks)
}, movie.name = "Ising.gif", interval = 0.1, nmax = 20)

}
\author{
Jiechao Xiong
}
\keyword{regression}

