% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexisplotr.R
\name{lexisplotr}
\alias{lexisplotr}
\title{Plot a Lexis Diagram.}
\usage{
lexisplotr(from_year, to_year, from_age, to_age, age, cohort, year, triangle,
  lifelines, colors = c("yellow", "green", "blue", "red", "purple"),
  title = "Lexis Diagram", envir = environment())
}
\arguments{
\item{from_year}{integer, set the year the Lexis Diagram starts with.}

\item{to_year}{integer, set the year the Lexis Diagram ends with.}

\item{from_age}{integer, set the age the Lexis Diagram starts with.}

\item{to_age}{integer, set the age the Lexis Diagram ends with.}

\item{age}{integer, set an age to emphasize.}

\item{cohort}{integer, set a cohort to emphasize.}

\item{year}{integer, set a year to emphasize.}

\item{triangle}{list, set triangles to be drawn. The list contains each lifeline
as a vector of a year-age-combination and a keyword to determine whether the upper \code{"u"}
or lower \code{"l"} triangle shall be drawn.}

\item{lifelines}{list, set lifelines to be drawn. The list contains each
lifeline as a vector specifying the date of the beginning of the observation 
and the date of the end of the observation. Dates in format \code{"dd.mm.yyyy"}.}

\item{colors}{vector, set the colors used for \code{cohort, year, age, lifelines, triangle}.
Default: \code{colors=c("yellow", "green", "blue", "red", "purple")}}

\item{title}{character, title of the plot. Default: "Lexis Diagram".}

\item{envir, }{Default: \code{environment()}. Should not be changed. Needed as a workarround.}
}
\value{
The functions returns a ggplot2-plot.
}
\description{
lexisplotr is an easy to use function to plot Lexis Diagrams.
}
\details{
Required date format: \code{"dd.mm.yyyy"}.

The function determines the aspect ratio of the x- and y-axis to enforce
isosceles triangles. The aspect ratio will not be effected by defining
\code{width} and \code{height} in \code{pdf()} or other graphic devices.

Because the returned object is a ggplot2 graph, the overall appearence of
the graph can be edited by adding e.g. \code{themes()} to the plot.
}
\note{
To save the plot, using \code{pdf()} is recommended since it will
achieve good results and avoid overlapping in most cases. Unix users may use
\code{x11()} to start a new graphical device to preview the plot.
}
\examples{
library(LexisPlotR)

## Plot a Lexis Diagram grid
lexisplotr(from_year=1900, to_year=1905, from_age=0, to_age=5)

## Emphasize a certain cohort, year and age
lexisplotr(from_year=1900, to_year=1905, from_age=0, to_age=5,
           cohort=1901, year=1903, age=2)
           
## Plot lifelines
lexisplotr(from_year=1900, to_year=1905, from_age=0, to_age=5,
           lifelines=list(c("30.06.1900", "23.09.1903"),
                          c("01.01.1901", "31.12.1904")))
                          
## Emphasize a certain triangles
lexisplotr(from_year=1900, to_year=1905, from_age=0, to_age=5,
           triangle=list(c(1901,2,"u"),c(1902,4,"l")))
          
## Change the size of the axis text
lexis <- lexisplotr(from_year=1900, to_year=1905, from_age=0, to_age=5)
lexis <- lexis + theme(axis.text = element_text(size=10))
lexis
}
\author{
Philipp Ottolinger
}
\seealso{
\code{\link{ggplot}}
}
\keyword{hplot}

