% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LexisNexisTools.R
\name{lnt_diff}
\alias{lnt_diff}
\title{Display diff of similar articles}
\usage{
lnt_diff(x, min = 0.15, max = 0.3, n = 25, output_html = FALSE, ...)
}
\arguments{
\item{x}{lnt_sim object as returned by \link{lnt_similarity}.}

\item{min}{Minimum value of rel_dist to include in diff.}

\item{max}{Maximum value of rel_dist to include in diff.}

\item{n}{Size of displayed sample.}

\item{output_html}{Set to TRUE to output html code, e.g. to use for knitting
an rmarkdown document to html. Chunk option must be set to
\code{results='asis'} in that case.}

\item{...}{Currently not used.}
}
\description{
This function is a wrapper for \link[diffobj]{diffPrint}. It is
  intended to help performing a manual assessment of the difference between
  highly similar articles identified via \link{lnt_similarity}.
}
\examples{
# Test similarity of articles
duplicates.df <- lnt_similarity(
  LNToutput = lnt_read(lnt_sample(copy = FALSE)),
  threshold = 0.97
)

lnt_diff(duplicates.df, min = 0.18, max = 0.30)
}
\author{
Johannes Gruber
}
