% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LexisNexisTools.R
\name{lnt_asDate}
\alias{lnt_asDate}
\title{Convert Strings to dates}
\usage{
lnt_asDate(x, format = "auto", locale = "auto")
}
\arguments{
\item{x}{A character object to be converted.}

\item{format}{Either "auto" to guess the format based on a common order of
day, month and year or provide a custom format (see
\link[stringi]{stri_datetime_format} for format options).}

\item{locale}{A ISO 639-1 locale code (see
\url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}).}
}
\value{
This function returns an object of class \link{date}.
}
\description{
Converts dates from string formats common in LexisNexis to a
  date object.
}
\examples{
LNToutput <- lnt_read(lnt_sample(copy = FALSE), convert_date = FALSE)
d <- lnt_asDate(LNToutput@meta$Date)
d
}
