% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JonckheereTerpstra.R
\name{JonckheereTerpstra}
\alias{JonckheereTerpstra}
\alias{ksample.jt}
\title{Jonckheere-Terpstra Test}
\description{
Performs Jonckheere-Terpstra test on samples.
}
\examples{
t <- pmt(
    "ksample.jt", alternative = "greater"
)$test(Table3.4.1)$print()

t$type <- "asymp"
t

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:KSampleTest]{LearnNonparam::KSampleTest}} -> \code{JonckheereTerpstra}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-JonckheereTerpstra-new}{\code{JonckheereTerpstra$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JonckheereTerpstra-new"></a>}}
\if{latex}{\out{\hypertarget{method-JonckheereTerpstra-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{JonckheereTerpstra} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JonckheereTerpstra$new(
  type = c("permu", "asymp"),
  alternative = c("two_sided", "less", "greater"),
  n_permu = 10000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{a character string specifying the way to calculate the p-value.}

\item{\code{alternative}}{a character string specifying the alternative hypothesis.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to zero (default) then all permutations are used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{JonckheereTerpstra} object.
}
}
}
