% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_LeMans.R
\name{comb_LeMans_run}
\alias{comb_LeMans_run}
\title{Combine two \code{LeMans_outputs} objects}
\usage{
comb_LeMans_run(LeMans_run_x, LeMans_run_y, cont = TRUE)
}
\arguments{
\item{LeMans_run_x}{A \linkS4class{LeMans_outputs} object.}

\item{LeMans_run_y}{A \linkS4class{LeMans_outputs} object.}

\item{cont}{A logical statement indicating whether or not \code{LeMans_run_y} is a continuation of \code{LeMans_run_x}. The default is \code{TRUE}.}
}
\value{
A \code{LeMans_outputs} object.
}
\description{
Combines two \linkS4class{LeMans_outputs} objects.
}
\details{
If \code{cont==T}, the first years output from \code{LeMans_run_y} is removed as this will be the same as the last year of \code{LeMans_run_x}.
}
\examples{
# Set up the inputs to the model
NS_params <- LeMansParam(NS_par, tau=NS_tau, eta=rep(0.25, 21), L50=NS_par$Lmat, other=NS_other)

# Define fishing effort
effort <- matrix(0.5, 10, dim(NS_params@Qs)[3])

# Run the model for the first time
model_run1 <- run_LeMans(NS_params, years=10, effort=effort)

# Run the model for another 12 years
effort1 <- matrix(0.5, 12, dim(NS_params@Qs)[3])
model_run2 <- run_LeMans(N=model_run1@N[,,101], NS_params, years=12, effort=effort1)

# Combine the two model runs into a single run
out <- comb_LeMans_run(model_run1, model_run2, cont=TRUE)
}
\seealso{
\linkS4class{LeMans_outputs}, \code{\link{run_LeMans}}
}
