% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lengthest.R
\name{lengthest}
\alias{lengthest}
\title{Performs width estimation for a numerical data set.}
\usage{
lengthest(x, error = c("laplace", "gauss", "student"), var = NULL,
  var.est = c("MM", "ML"), conf.level = 0.95)
}
\arguments{
\item{x}{Vector of input data.}

\item{error}{A character string specifying the error distribution. Must be
one of "laplace", "gauss" or "student". Can be abbreviated.}

\item{var}{Explicit error variance. Needs to be given if \code{var.est} is
not given.}

\item{var.est}{A character string specifying the method of error variance
estimation. Must be given if \code{var} is not given. Can be "MM" (Method
of Moments) or "ML" (Maximum Likelihood).}

\item{conf.level}{Confidence level of the confidence interval.}
}
\value{
List containing:
  \itemize{
    \item error.type: A character string describing the type of the
      error distribution.
    \item radius: Estimated half-width of uniform distribution.
    \item var.error: Error variance, estimated or given.
    \item conf.level: Confidence level of the confidence interval.
    \item method: A character string indicating what method for
      computing a confidence interval was used (asymptotic distribution of
      ML or likelihood ratio statistic).
    \item conf.int: The confidence interval for half-width.
  }
}
\description{
Function \code{lengthest()} computes the length of an interval which is the
domain of uniform distribution from data contaminated with additive error.
The additive error can be chosen as Laplace, Gauss or scaled Student
distribution with 5 degrees of freedom.
}
\examples{
# generate uniform data with additive error and run a length estimation on it
sample_1 <- runif(1000, -1, 1)
sample_2 <- rnorm(1000, 0, 0.1)
sample <- sample_1 + sample_2
out <- lengthest(x = sample, error = "gauss", var.est = "MM", conf.level = 0.90)

}
