% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_m1.R
\name{p_m1}
\alias{p_m1}
\title{Non-principal branch probability}
\usage{
p_m1(gamma, beta, distname, n = 1, use.mean.variance = TRUE)
}
\arguments{
\item{gamma}{scalar; skewness parameter.}

\item{beta}{numeric vector (deprecated); parameter \eqn{\boldsymbol \beta} of
the input distribution.  See \code{\link{check_beta}} on how to specify
\code{beta} for each distribution.}

\item{distname}{character; name of input distribution; see
\code{\link{get_distnames}}.}

\item{n}{number of RVs/observations.}

\item{use.mean.variance}{logical; if \code{TRUE} it uses mean and variance
implied by \eqn{\boldsymbol \beta} to do the transformation (Goerg 2011).
If \code{FALSE}, it uses the alternative definition from Goerg (2016)
with location and scale parameter.}
}
\value{
non-negative float; the probability \eqn{p_{-1}} for \code{n} observations.
}
\description{
Computes the probability that (at least) one (out of n)
    observation(s) of the latent variable \eqn{U} lies in the non-principal
    branch region. The '\code{m1}' in \code{p_m1} stands for 'minus 1', i.e,
    the non-principal branch.

See Goerg (2011) and Details for mathematical derivations.
}
\details{
The probability that one observation of the latent RV U lies in the
non-principal region equals at most \deqn{ p_{-1}(\gamma, n=1)
= P\left(U < -\frac{1}{|\gamma|}\right), } where \eqn{U} is the zero-mean,
unit variance version of the input \eqn{X \sim F_X(x \mid \boldsymbol
\beta)} -- see References.

For \eqn{N} independent RVs \eqn{U_1, \ldots, U_N}, the probability that at
least one data point came from the non-principal region equals
\deqn{
p_{-1}(\gamma, n=N) = P\left(U_i < -\frac{1}{|\gamma|} \; for \; at \;
least \; one \; i \right) } 

This equals (assuming independence) 
\deqn{ P\left(U_i < -\frac{1}{|\gamma|} \; for \; at
\; least \; one \; i \right) = 1 - P\left(U_i \geq -\frac{1}{|\gamma|},
\forall i \right) = 1 - \prod_{i=1}^{N} P\left(U_i \geq -\frac{1}{|\gamma|}
\right) } \deqn{ = 1 - \prod_{i=1}^{N} \left(1 - p_{-1}(\gamma, n=1) \right)
= 1 - (1-p_{-1}(\gamma, n=1))^N. }

For improved numerical stability the cdf of a geometric RV
(\code{\link[stats]{pgeom}}) is used to evaluate the last
expression. Nevertheless, numerical problems can occur for \eqn{|\gamma| <
0.03} (returns \code{0} due to rounding errors).

Note that \eqn{1 - (1-p_{-1}(\gamma, n=1))^N} reduces to \eqn{p_{-1}(\gamma)}
for \eqn{N=1}.
}
\examples{

beta.01 <- c(mu = 0, sigma = 1)
# for n=1 observation
p_m1(0, beta = beta.01, distname = "normal") # identical to 0
# in theory != 0; but machine precision too low
p_m1(0.01, beta = beta.01, distname = "normal") 
p_m1(0.05, beta = beta.01, distname = "normal") # extremely small
p_m1(0.1, beta = beta.01, distname = "normal") # != 0, but very small
# 1 out of 4 samples is a non-principal input;
p_m1(1.5, beta = beta.01, distname = "normal") 
# however, gamma=1.5 is not common in practice

# for n=100 observations
p_m1(0, n=100, beta = beta.01, distname = "normal") # == 0
p_m1(0.1, n=100, beta = beta.01, distname = "normal") # still small
p_m1(0.3, n=100, beta = beta.01, distname = "normal") # a bit more likely
p_m1(1.5, n=100, beta = beta.01, distname = "normal") 
# Here we can be almost 100\% sure (rounding errors) that at least one
# y_i was caused by an input in the non-principal branch.

}
\keyword{univar}

