% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_01.R
\name{gamma_01}
\alias{gamma_01}
\title{Input parameters to get a zero mean, unit variance output for a given gamma}
\usage{
gamma_01(gamma, mu.y = 0, sigma.y = 1, distname = "normal")
}
\arguments{
\item{gamma}{skewness parameter}

\item{mu.y}{output mean; default: \code{0}.}

\item{sigma.y}{output standard deviation; default: \code{1}.}

\item{distname}{string; name of distribution. Currently only supports \code{"normal"}.}
}
\value{
A 5-dimensional vector (\eqn{\mu_x(\gamma)}, \eqn{\sigma_x(\gamma)}, \eqn{\gamma}, 0, 1),
where \eqn{\delta = 0} and \eqn{\alpha = 1} are set for the sake of compatiblity with 
other functions.
}
\description{
Computes the input mean \eqn{\mu_x(\gamma)} and standard deviation 
\eqn{\sigma_x(\gamma)} for input \eqn{X \sim F(x \mid \boldsymbol \beta)}
such that the resulting skewed Lambert W x F RV \eqn{Y} with 
\eqn{\gamma} has zero-mean and unit-variance.  So far works only for Gaussian 
input and scalar \eqn{\gamma}.

The function works for any output mean and standard deviation, but
\eqn{\mu_y = 0} and \eqn{\sigma_y = 1} are set as default as they 
are the most useful, e.g., to generate a standardized Lambert W white noise 
sequence.
}
\examples{

gamma_01(0) # for gamma = 0, input == output, therefore (0,1,0,0,1)
# input mean must be slightly negative to get a zero-mean output
gamma_01(0.1) # gamma = 0.1 means it is positively skewed
gamma_01(1)

}
\keyword{math}

