% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_distname-utils.R, R/check_distname.R, R/get_distname_family.R, R/get_distnames.R
\name{distname-utils}
\alias{check_distname}
\alias{distname-utils}
\alias{get_distname_family}
\alias{get_distnames}
\title{Utilities for distributions supported in this package}
\usage{
check_distname(distname)

get_distname_family(distname)

get_distnames()
}
\arguments{
\item{distname}{character; name of input distribution; see
\code{\link{get_distnames}}.}
}
\value{
\code{check_distname} returns (invisible) that the distribution is implemented, 
or throws an error otherwise.

\code{get_distname_family} returns a list with
\item{location}{ logical; if \code{TRUE}, the distribution is a location family,}
\item{scale}{ logical; if \code{TRUE}, the distribution is a scale family.}
\item{is.non.negative}{ logical; if \code{TRUE}, the distribution has support only for
the non-negative reals (this is usually the case when \code{location = FALSE}
and \code{scale = TRUE})}

\code{get_distnames} returns a vector of strings in alphabetical order. 
It lists all supported distributions. 
Each string can be passed as the \code{distname} argument to several functions in this package.
}
\description{
The Lambert W\eqn{\times} F framework can take any (continuous) random variable with distribution
F and make it skewed (\code{type = "s"}), heavy tailed (\code{type = "h"}),
or both (\code{type = "hh"}).

In principle, this works for any F.  Of course, this package implements only a finite
number of distributions, which can be specified with the \code{distname} argument.
Most functions in this package, however, also allow you to pass your own distribution and parameters
and create a Lambert W\eqn{\times} F version of it.

\code{check_distname} checks if the distribution specified by
the \code{distname} argument is implemented in this package.

\code{get_distname_family} determines whether a distribution is a 
location, scale, or location-scale family. 
It also returns whether the distribution is supported on non-negative
values only.

\code{get_distnames} lists all currently implemented distributions \eqn{F_X}.
}
\examples{

check_distname("normal")
\dontrun{
check_distname("my_great_distribution")
}

get_distname_family("normal")
}
\seealso{
\code{\link{create_LambertW_input}}, \code{\link{create_LambertW_output}}.
}
\keyword{misc}

