% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/0_beta-utils.R, R/beta2tau.R, R/check_beta.R, R/estimate_beta.R, R/get_beta_names.R
\name{beta-utils}
\alias{beta-utils}
\alias{beta2tau}
\alias{check_beta}
\alias{estimate_beta}
\alias{get_beta_names}
\title{Utilities for parameter vector beta of the input distribution}
\usage{
beta2tau(beta, distname)

check_beta(beta, distname)

estimate_beta(x, distname)

get_beta_names(distname)
}
\arguments{
\item{beta}{numeric; vector \eqn{\boldsymbol \beta} of the input
distribution; specifications as they are for the R implementation of this
distribution. For example, if \code{distname = "exp"}, then \code{beta = 2}
means that the rate of the exponential distribution equals \eqn{2}; if
\code{distname = "normal"} then \code{beta = c(1,2)} means that the mean and
standard deviation are 1 and 2, respectively.}

\item{distname}{string; name of input distribution; see \code{\link{get_distnames}}.}

\item{x}{a numeric vector of real values (the \emph{input} data).}
}
\value{
\code{beta2tau} returns a numeric vector, which is the \eqn{\tau} vector implied
by \code{beta} and \code{distname}.

\code{check_beta} throws an error if \eqn{\boldsymbol \beta} is not
appropriate for the given distribution; e.g., if it has too many values or if
they are not within proper bounds (e.g., \code{beta['sigma']} of a \code{"normal"}
distribution must be positive).

\code{estimate_beta} returns a named vector with estimates for
\eqn{\boldsymbol \beta}.

\code{get_beta_names} returns a vector of strings for each element of \code{beta}.
}
\description{
The vector \eqn{\boldsymbol \beta} parametrizes the input distribution
\eqn{X \sim F_X(x \mid \boldsymbol \beta)}. Depending on the distribution
\eqn{\boldsymbol \beta} has different length and names: e.g.,
for a \code{"normal"} distribution \code{beta} is of length
\eqn{2} (\code{"mu"}, \code{"sigma"}); for an \code{"exp"}onential
distribution \code{beta} is a scalar (rate \code{"lambda"}).

\code{beta2tau} converts \eqn{\boldsymbol \beta} to
the parameter \eqn{\tau = (\mu_x, \sigma_x, \gamma = 0, \alpha = 1, \delta = 0)},
which defines the Lambert W\eqn{\times} F random variable transformation from
\eqn{X} to \eqn{Y} (see \code{\link{tau-utils}}). Note that mean
\eqn{\mu_x} and standard deviation \eqn{\sigma_x} of \eqn{X} in general depend
on \eqn{\boldsymbol \beta}.

\code{check_beta} checks if \eqn{\boldsymbol \beta} defines a valid distribution.
E.g., for normal distribution \code{'sigma'} must be positive.

\code{estimate_beta} estimates parameter \eqn{\boldsymbol \beta} for a given
input distribution using MLE or methods of momments.  Closed form solutions
are used if they exist; otherwise the MLE is obtained numerically using
\code{\link[MASS]{fitdistr}}.

\code{get_beta_names} returns (typical) names for \eqn{\boldsymbol \beta}
and the given distribution. E.g., for a \code{'normal'} distribution the names of the
two-dimenstional \code{beta} are \code{'mu'} and \code{'sigma'}.
}
\details{
Note that \code{estimate_beta} does not do any data transformation as part
of the Lambert W\eqn{\times} F input/output framework.
For an initial estimate of \eqn{\theta} in the Lambert W\eqn{\times} F estimation see
\code{\link{get_initial_theta}} and \code{\link{get_initial_tau}}.
}
\examples{
# By default: delta = gamma = 0 and alpha = 1
beta2tau(c(1, 1), distname = "normal")
\dontrun{
beta2tau(c(1, 4, 1), distname = "t")
}
beta2tau(c(1, 4, 3), distname = "t") # no problem
\dontrun{
check_beta(beta = c(1, 1, -1), distname = "normal")
}
set.seed(124)
xx <- rnorm(100)^2
estimate_beta(xx, "exp")
estimate_beta(xx, "chisq")
get_beta_names("normal")
get_beta_names("exp")
}
\seealso{
\code{\link{tau-utils}}, \code{\link{theta-utils}}
}
\keyword{math}
\keyword{utilities}

