% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_rm_multicol.R
\name{rm_multicol}
\alias{rm_multicol}
\title{rm_multicol}
\usage{
rm_multicol(
  dir2process = NULL,
  multicol_cutoff = 0.7,
  cores2use = 1,
  filename = "",
  ...
)
}
\arguments{
\item{dir2process}{Character. Directory where the Raster* objects are stored. All the .tif
files in the directory will be read in to be used}

\item{multicol_cutoff}{Numeric. Cutoff value of (Pearson's) correlation. Optional. Default is 0.70}

\item{cores2use}{Numeric. Number of cores to use for parallelization. Optional. Default is 1 (no parallelization)}

\item{filename}{Character. Output filename. Optional}

\item{...}{Optional. Arguments for removeCollinearity()}
}
\value{
RasterBrick object
}
\description{
rm_multicol calculates the average of each variable and removes those variables highly correlated
}
\details{
Firstly, after reading in all .tif files in 'dir2process', if they are multiband (time series), averages are
calculated. Secondly, it creates a RasterBrick object with those (averaged) variables which have a Pearson's
correlation coefficient below 'multicol_cutoff'. See \code{\link[virtualspecies]{removeCollinearity}} for further arguments
and functionalities
}
\examples{
\donttest{
dirctry <- paste0(system.file(package='LPDynR'), "/extdata")  # directory with variables to process
rm_multicol(dir2process = dirctry,
            multicol_cutoff = 0.7,
            plot = TRUE)
}
}
\references{
Leroy B, Meynard CN, Bellard C, Courchamp F (2015). “virtualspecies, an R package to generate virtual species distributions”. Ecography. doi: 10.1111/ecog.01388
}
\seealso{
\code{\link[virtualspecies]{removeCollinearity}}
}
\author{
Xavier Rotllan-Puig
}
