% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChisquarePlot.R
\name{ChiSquarePlot}
\alias{ChiSquarePlot}
\title{Plot for Chi-square Statistics}
\usage{
ChiSquarePlot(
  trainingdata = NULL,
  nfeatureNames = NULL,
  outcome = NULL,
  level = NULL,
  ModelObject = NULL
)
}
\arguments{
\item{trainingdata}{A data set used for training}

\item{nfeatureNames}{A vector of feature names that will be used for computing chi-square statistics}

\item{outcome}{A character string with the name of the binary outcome variable.}

\item{level}{A numerical value indicating the number of categories that the outcome contains}

\item{ModelObject}{A model object containing tree-based models}
}
\value{
This function returns a barplot of scaled chi-square statistics for the study’s features. These measures were computed as described by He & von Davier (2015).
}
\description{
Plot for Chi-square Statistics
}
\examples{
\donttest{
colnames(training)[14] <- "perf"
ensemblist <- TreeModels(traindata = training,
methodlist = c("dt", "gbm"),checkprogress = TRUE)

ChiSquarePlot(trainingdata = training,
nfeatureNames = colnames(training[,7:13]),
outcome = "perf", level = 2, ModelObject = ensemblist$ModelObject)
}
}
\references{
He, Q., & von Davier, M. (2015). Identifying feature sequences from process data in problem-solving items with N-grams. In Quantitative Psychology Research: The 79th Annual Meeting of the Psychometric Society (pp. 173–190). Madison, Wisconsin: Springer International Publishing.
}
