% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmn_loglik.R
\name{lmn_loglik}
\alias{lmn_loglik}
\title{Loglikelihood function for LMN models.}
\usage{
lmn_loglik(Beta, Sigma, suff)
}
\arguments{
\item{Beta}{A \verb{p x q} matrix of regression coefficients (see \code{\link[=lmn_suff]{lmn_suff()}}).}

\item{Sigma}{A \verb{q x q} matrix of error variances (see \code{\link[=lmn_suff]{lmn_suff()}}).}

\item{suff}{An object of class \code{lmn_suff} (see \code{\link[=lmn_suff]{lmn_suff()}}).}
}
\value{
Scalar; the value of the loglikelihood.
}
\description{
Loglikelihood function for LMN models.
}
\examples{
# generate data
n <- 50
q <- 3
Y <- matrix(rnorm(n*q),n,q) # response matrix
X <- 1 # intercept covariate
V <- 0.5 # scalar variance specification
suff <- lmn_suff(Y, X = X, V = V) # sufficient statistics

# calculate loglikelihood
Beta <- matrix(rnorm(q),1,q)
Sigma <- diag(rexp(q))
lmn_loglik(Beta = Beta, Sigma = Sigma, suff = suff)
}
