\name{Xranges}
\alias{Xranges}
\title{
  Generates ranges of the unknowns of a linear inverse problem
}

\description{
  Given an inverse input list, generates the minimal and maximal
  values of the unknowns
}
\usage{
Xranges (lim, ...)
}

\arguments{
  \item{lim }{a list that contains the linear inverse model
    specification, as  generated by function \code{setup.limfile}.
  }
  \item{... }{extra arguments passed to function
    \code{\link[limSolve]{xranges}} from package\code{limSolve}.
  }
}

\value{
  a 2-columned vector containing the minimum (column 1) and
  maximum (column 2) of each unknown.
}
\author{
  Karline Soetaert <karline.soetaert@nioz.nl>
}

\examples{
# ranges
xr   <- Xranges(LIMRigaAutumn)
xlim <- range(xr)

# parsimonious
pars <- Lsei(LIMRigaAutumn)$X

# plot
dotchart(x = pars, labels = rownames(xr), xlim = xlim,  
         main = "Riga Autumn ",
         sub = "ranges and parsimonious solution", pch = 16)
cc <- 1:nrow(xr)
segments(xr[ ,1], cc, xr[ ,2], cc)}
\seealso{
  \code{\link{Varranges}} which estimates the ranges of inverse variables

  \code{\link{Plotranges}} to plot the ranges

  function \code{\link[limSolve]{xranges}} from package\code{limSolve}
}

\keyword{optimize}
\keyword{utilities}

