% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OASA.R
\name{OASA}
\alias{OASA}
\title{Orthogonal-Array-Based Simulated Annealing}
\usage{
OASA(
  OA,
  N = 10,
  T0 = 10,
  rate = 0.1,
  Tmin = 1,
  Imax = 5,
  OC = "phi_p",
  p = 15,
  q = 1
)
}
\arguments{
\item{OA}{A Matrix.}

\item{N}{A positive integer.}

\item{T0}{A positive number.}

\item{rate}{A positive percentage.}

\item{Tmin}{A positive number.}

\item{Imax}{A positive integer.}

\item{OC}{An optimality criterion.}

\item{p}{A positive integer.}

\item{q}{The default is set to be 1, and it could be either 1 or 2.}
}
\value{
If all inputs are logical, then the output will be an LHD whose sizes are the same as input OA.
}
\description{
\code{OASA} returns an LHD matrix generated by orthogonal-array-based simulated annealing algorithm (OASA)
}
\details{
\itemize{
\item \code{OA} stands for the input orthogonal array matrix.
\item \code{N} stands for the number of iterations. The default is set to be 10.
\item \code{T0} stands for the user-defined initial temperature. The default is set to be 10.
\item \code{rate} stands for temperature decrease rate, and it should be in (0,1). For example, rate=0.25 means the temperature decreases by 25\% each time. The default is set to be 10\%.
\item \code{Tmin} stands for the minimium temperature allowed. When current temperature becomes smaller or equal to \code{Tmin}, the stopping criterion for current loop is met. The default is set to be 1.
\item \code{Imax} stands for the maximum perturbations the algorithm will try without improvements before temperature is reduced. For the computation complexity consideration, \code{Imax} is recommended to be smaller or equal to 5, which is the default setting.
\item \code{OC} stands for the optimality criterion, the default setting is "phi_p", and it could be one of the following: "phi_p", "AvgAbsCor", "MaxAbsCor", "MaxProCriterion".
\item \code{p} is the parameter in the phi_p formula, and \code{p} is prefered to be large. The default is set to be 15.
\item If \code{q} is 1 (the default setting), \code{dij} is the rectangular distance. If \code{q} is 2, \code{dij} is the Euclidean distance.
}
}
\note{
The assumption is that the elements of OAs must be positive.
}
\examples{
#create an OA(9,2,3,2)
OA=matrix(c(rep(1:3,each=3),rep(1:3,times=3)),ncol=2,nrow=9,byrow = FALSE);OA

#Use above "OA" as the input OA to generate a 9 by 2 maximin distance LHD
#with the default setting
tryOASA=OASA(OA=OA)
tryOASA
phi_p(tryOASA)   #calculate the phi_p of "tryOASA".

#Another example
#generate a 9 by 2 nearly orthogonal LHD
tryOASA2=OASA(OA=OA,OC="MaxAbsCor")
tryOASA2
MaxAbsCor(tryOASA2)  #calculate the maximum absolute correlation.
}
\references{
Leary, S., Bhaskar, A., and Keane, A. (2003) Optimal orthogonal-array-based latin hypercubes. \emph{Journal of Applied Statistics}, \strong{30}, 585-598.
}
