% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAPC_LFM.R
\name{SAPC_LFM}
\alias{SAPC_LFM}
\title{Apply the SAPC method to the Laplace factor model}
\usage{
SAPC_LFM(data, m, A, D, p)
}
\arguments{
\item{data}{The data used in the SAPC analysis.}

\item{m}{The number of common factors.}

\item{A}{The true factor loadings matrix.}

\item{D}{The true uniquenesses matrix.}

\item{p}{The number of variables.}
}
\value{
A list of metrics including:
\item{Asa}{Estimated factor loadings matrix obtained from the SAPC analysis.}
\item{Dsa}{Estimated uniquenesses vector obtained from the SAPC analysis.}
\item{MSESigmaA}{Mean squared error of the estimated factor loadings (Asa) compared to the true loadings (A).}
\item{MSESigmaD}{Mean squared error of the estimated uniquenesses (Dsa) compared to the true uniquenesses (D).}
\item{LSigmaA}{Loss metric for the estimated factor loadings (Asa), indicating the relative error compared to the true loadings (A).}
\item{LSigmaD}{Loss metric for the estimated uniquenesses (Dsa), indicating the relative error compared to the true uniquenesses (D).}
}
\description{
This function calculates several metrics for the SAPC method,
including the estimated factor loadings and uniquenesses, and various
error metrics comparing the estimated matrices with the true matrices.
}
\examples{
library(SOPC)
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- SAPC_LFM(data, m, A, D, p)
print(results)
}
