% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LEGIT.R
\name{bootstrap_var_select}
\alias{bootstrap_var_select}
\title{Bootstrap variable selection (for IMLEGIT)}
\usage{
bootstrap_var_select(data, formula, boot_iter = 1000, boot_size = NULL,
  boot_group = NULL, latent_var_original = NULL, latent_var_extra = NULL,
  search_type = "bidirectional-forward", search = 0,
  search_criterion = "AIC", forward_exclude_p_bigger = 0.2,
  backward_exclude_p_smaller = 0.01, exclude_worse_AIC = TRUE,
  max_steps = 100, start_latent_var = NULL, eps = 0.01, maxiter = 100,
  family = gaussian, seed = NULL, progress = TRUE, n_cluster = 1,
  best_subsets = 5)
}
\arguments{
\item{data}{data.frame of the dataset to be used.}

\item{formula}{Model formula. The names of \code{latent_var} can be used in the formula to represent the latent variables. If names(\code{latent_var}) is NULL, then L1, L2, ... can be used in formula to represent the latent variables. Do not manually code interactions, write them in the formula instead (ex: G*E1*E2 or G:E1:E2).}

\item{boot_iter}{number of bootstrap samples (Default = 1000).}

\item{boot_size}{Optional size of the bootstrapped samples (Default = number of observations).}

\item{boot_group}{Optional vector which represents the group associated with each observation. Sampling will be done by group instead of by observations (very important if you have longitudinal data). The sample sizes of the bootstrap samples might differ by up to "\code{boot_size} - maximum group size" observations.}

\item{latent_var_original}{list of data.frame. The elements of the list are the datasets used to construct each latent variable. For interpretability and proper convergence, not using the same variable in more than one latent variable is highly recommended. It is recommended to set names to the list elements to prevent confusion because otherwise the latent variables will be named L1, L2, ...}

\item{latent_var_extra}{list of data.frame (with the same structure as latent_var_original) containing the additional elements to try including inside the latent variables. Set to NULL if using a backward search.}

\item{search_type}{If \code{search_type="forward"}, uses a forward search. If \code{search_type="backward"}, uses backward search. If \code{search_type="bidirectional-forward"}, uses bidirectional search (that starts as a forward search). If \code{search_type="bidirectional-backward"}, uses bidirectional search (that starts as a backward search).}

\item{search}{If \code{search=0}, uses a stepwise search for all latent variables. Otherwise, if search = i, uses a stepwise search on the i-th latent variable (Default = 0).}

\item{search_criterion}{Criterion used to determine which variable is the best to add or worst to drop. If \code{search_criterion="AIC"}, uses the AIC, if \code{search_criterion="AICc"}, uses the AICc, if \code{search_criterion="BIC"}, uses the BIC (Default = "AIC").}

\item{forward_exclude_p_bigger}{If p-value > \code{forward_exclude_p_bigger}, we do not consider the variable for inclusion in the forward steps (Default = .20). This is an exclusion option which purpose is skipping variables that are likely not worth looking to make the algorithm faster, especially with cross-validation. Set to 1 to prevent any exclusion here.}

\item{backward_exclude_p_smaller}{If p-value < \code{backward_exclude_p_smaller}, we do not consider the variable for removal in the backward steps (Default = .01). This is an exclusion option which purpose is skipping variables that are likely not worth looking to make the algorithm faster, especially with cross-validation. Set to 0 to prevent any exclusion here.}

\item{exclude_worse_AIC}{If AIC with variable > AIC without variable, we ignore the variable (Default = TRUE). This is an exclusion option which purpose is skipping variables that are likely not worth looking to make the algorithm faster, especially with cross-validation. Set to FALSE to prevent any exclusion here.}

\item{max_steps}{Maximum number of steps taken (Default = 50).}

\item{start_latent_var}{Optional list of starting points for each latent variable (The list must have the same length as the number of latent variables and each element of the list must have the same length as the number of variables of the corresponding latent variable).}

\item{eps}{Threshold for convergence (.01 for quick batch simulations, .0001 for accurate results).}

\item{maxiter}{Maximum number of iterations.}

\item{family}{Outcome distribution and link function (Default = gaussian).}

\item{seed}{Optional seed for bootstrap.}

\item{progress}{If TRUE, shows the progress done (Default=TRUE).}

\item{n_cluster}{Number of parallel clusters, I recommend using the number of CPU cores - 1 (Default = 1).}

\item{best_subsets}{If \code{best_subsets = k}, the output will show the k most frequently chosen subsets of variables (Default = 5)}
}
\value{
Returns a list of vectors containing the percentage of times that each variable was selected within each latent variable.
}
\description{
Creates bootstrap samples, run stepwise search on all of them and then report the percentage of times that each variable was selected. This is very computationally demanding. With small sample sizes, variable selection can be unstable and bootstrap can be used to give us an idea of the degree of certitude that a variable should be included or not.
}
\examples{
\dontrun{
## Example
train = example_3way_3latent(250, 2, seed=777)
# Bootstrap with Bidirectional-backward search for everything based on AIC
# Normally you should use a lot more than 10 iterations and extra CPUs (n_cluster)
boot = bootstrap_var_select(train$data, latent_var_extra=NULL, 
latent_var_original=train$latent_var,
formula=y ~ E*G*Z,search_type="bidirectional-backward", search=0, 
search_criterion="AIC", boot_iter=10, n_cluster=1)
# Assuming it's longitudinal with 5 timepoints, even though it's not
id = factor(rep(1:50,each=5))
boot_longitudinal = bootstrap_var_select(train$data, latent_var_extra=NULL, 
latent_var_original=train$latent_var,
formula=y ~ E*G*Z,search_type="bidirectional-backward", search=0, 
search_criterion="AIC", boot_iter=10, n_cluster=1, boot_group=id)
}
}
\references{
Peter C Austin and Jack V Tu. \emph{Bootstrap Methods for Developing Predictive Models} (2012). dx.doi.org/10.1198/0003130043277.

Mark Reiser, Lanlan Yao, Xiao Wang, Jeanne Wilcox and Shelley Gray. \emph{A Comparison of Bootstrap Confidence Intervals for Multi-level Longitudinal Data Using Monte-Carlo Simulation} (2017). 10.1007/978-981-10-3307-0_17.
}
