% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDhap.R
\name{LDhap}
\alias{LDhap}
\title{Calculates population specific haplotype frequencies of all
haplotypes observed for a list of query variants.}
\usage{
LDhap(
  snps,
  pop = "CEU",
  token = NULL,
  file = FALSE,
  table_type = "haplotype",
  genome_build = "grch37",
  api_root = "https://ldlink.nci.nih.gov/LDlinkRest"
)
}
\arguments{
\item{snps}{list of between 1 - 30 variants, using an rsID or chromosome coordinate (e.g. "chr7:24966446")}

\item{pop}{a 1000 Genomes Project population, (e.g. YRI or CEU), multiple allowed, default = "CEU"}

\item{token}{LDlink provided user token, default = NULL, register for token at  \url{https://ldlink.nci.nih.gov/?tab=apiaccess}}

\item{file}{Optional character string naming a path and file for saving results.  If file = FALSE, no file will be generated, default = FALSE.}

\item{table_type}{Choose from one of four options available to determine output
format type...`haplotype`, `variant`, `both` and `merged`. Default = "haplotype".}

\item{genome_build}{Choose between one of the three options...`grch37` for genome build GRCh37 (hg19),
`grch38` for GRCh38 (hg38), or `grch38_high_coverage` for GRCh38 High Coverage (hg38) 1000 Genome Project
data sets.  Default is GRCh37 (hg19).}

\item{api_root}{Optional alternative root url for API.}
}
\value{
a data frame or list
}
\description{
Calculates population specific haplotype frequencies of all
haplotypes observed for a list of query variants.
}
\examples{
\dontrun{LDhap(c("rs3", "rs4", "rs148890987"), "CEU", token = Sys.getenv("LDLINK_TOKEN"))}
\dontrun{LDhap("rs148890987", c("YRI", "CEU"), token = Sys.getenv("LDLINK_TOKEN"))}

}
