% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jensen-Shannon.R
\name{JSD}
\alias{JSD}
\title{Calculate the Jensen-Shannon divergence (JSD)}
\usage{
JSD(vec1, vec2)
}
\arguments{
\item{vec1}{The vector containing the values of the first data set.}

\item{vec2}{The vector containing the values of the second data set.}
}
\value{
The function returns the value of the Jensen-Shannon divergence (JSD),
the frequencies of the two datasets (freq1, freq2, dfFreqs) and the
probabilities of the frequencies of the two groups, which should sum up
to 1.
}
\description{
Calculate the Jensen-Shannon divergence between the same
parameter of different
data sets. This works only for two distributions.
}
\examples{
\dontrun{
JSDCalc = JSD(model[["trainData"]]$LDLd,model[["testData"]]$LDLd)
}
}
\references{
D.M. Endres, J.E. Schindelin, A new metric for probability distributions, IEEE
Trans. Inf. Theory (2003), https://doi.org/10.1109/TIT.2003.813506.

F. Oesterreicher, I. Vajda, A new class of metric divergences on probability spaces
and its applicability in statistics, Ann. Inst. Stat. Math. (2003), https://doi.org/
10.1007/BF02517812.
}
