% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptMCMC.R
\name{prep_saves}
\alias{prep_saves}
\alias{update_saves}
\alias{process_saves}
\title{Prepare and update the data structures to save the ptMCMC output}
\usage{
prep_saves(nchangepoints, control = list())

update_saves(i, saves, steps, swaps)

process_saves(saves, control = list())
}
\arguments{
\item{nchangepoints}{\code{integer} corresponding to the number of 
change points to include in the model. 0 is a valid input (corresponding
to no change points, so a singular time series model), and the current 
implementation can reasonably include up to 6 change points. The 
number of change points is used to dictate the segmentation of the data  
for each continuous model and each LDA model.}

\item{control}{A \code{list} of parameters to control the fitting of the
Time Series model including the parallel tempering Markov Chain 
Monte Carlo (ptMCMC) controls. Values not input assume defaults set by 
\code{\link{TS_control}}.}

\item{i}{\code{integer} iteration index.}

\item{saves}{The existing list of saved data objects.}

\item{steps}{Chain configuration after within-temperature steps.}

\item{swaps}{Chain configuration after among-temperature swaps.}
}
\value{
\code{list} of ptMCMC objects: change points (\code{$cpts}), 
  log-likelihoods (\code{$lls}), chain ids (\code{$ids}), step acceptances
  (\code{$step_accepts}), and swap acceptances (\code{$swap_accepts}).
}
\description{
\code{prep_saves} creates the data structure used to save the 
  output from each iteration of the ptMCMC algorithm, which is added via
  \code{update_saves}. Once the ptMCMC is complete, the saved data objects
  are then processed (burn-in iterations are dropped and the remaining
  iterations are thinned) via \code{process_saves}.
  \cr \cr
  This set of functions was designed to work within \code{\link{TS}} and 
  specifically \code{\link{est_changepoints}}. They are still hardcoded to
  do so, but have the capacity to be generalized to work with any
  estimation via ptMCMC with additional coding work.
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDA_models <- LDA_set(document_term_table, topics = 2)[[1]]
  data <- document_covariate_table
  data$gamma <- LDA_models@gamma
  weights <- document_weights(document_term_table)
  data <- data[order(data[,"newmoon"]), ]
  saves <- prep_saves(1, TS_control())
  inputs <- prep_ptMCMC_inputs(data, gamma ~ 1, 1, "newmoon", weights, 
                               TS_control())
  cpts <- prep_cpts(data, gamma ~ 1, 1, "newmoon", weights, TS_control())
  ids <- prep_ids(TS_control())
  for(i in 1:TS_control()$nit){
    steps <- step_chains(i, cpts, inputs)
    swaps <- swap_chains(steps, inputs, ids)
    saves <- update_saves(i, saves, steps, swaps)
    cpts <- update_cpts(cpts, swaps)
    ids <- update_ids(ids, swaps)
  }
  process_saves(saves, TS_control())
}

}
