% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptMCMC.R
\name{count_trips}
\alias{count_trips}
\title{Count trips of the ptMCMC particles}
\usage{
count_trips(ids)
}
\arguments{
\item{ids}{\code{matrix} of identifiers of the particles in each chain for 
each iteration of the ptMCMC algorithm (rows: chains, 
columns: iterations).}
}
\value{
\code{list} of [1] \code{vector} of within particle trip counts 
  (\code{$trip_counts}), and [2] \code{vector} of within-particle average 
  trip rates (\code{$trip_rates}).
}
\description{
Count the full trips (from one extreme temperature chain to
  the other and back again; Katzgraber \emph{et al.} 2006) for each of the
  ptMCMC particles, as identified by their id on initialization.
  \cr \cr
  This function was designed to work within \code{\link{TS}} and process
  the output of \code{\link{est_changepoints}} as a component of 
  \code{\link{diagnose_ptMCMC}}, but has been generalized
  and would work with any output from a ptMCMC as long as \code{ids}
  is formatted properly.
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDA_models <- LDA_set(document_term_table, topics = 2)[[1]]
  data <- document_covariate_table
  data$gamma <- LDA_models@gamma
  weights <- document_weights(document_term_table)
  data <- data[order(data[,"newmoon"]), ]
  rho_dist <- est_changepoints(data, gamma ~ 1, 1, "newmoon", weights,
                               TS_control())
  count_trips(rho_dist$ids)
}

}
\references{
Katzgraber, H. G., S. Trebst, D. A. Huse. And M. Troyer. 2006. 
  Feedback-optimized parallel tempering Monte Carlo. \emph{Journal of 
  Statistical Mechanics: Theory and Experiment} \strong{3}:P03018
  \href{https://bit.ly/2LICGXh}{link}.
}
