% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA.R
\name{LDA_set}
\alias{LDA_set}
\alias{check_LDA_set_inputs}
\title{Run a set of Latent Dirichlet Allocation models}
\usage{
LDA_set(document_term_table, topics = 2, nseeds = 1,
  control = list())

check_LDA_set_inputs(document_term_table, topics, nseeds, control)
}
\arguments{
\item{document_term_table}{Table of observation count data (rows: 
documents, columns: terms. May be a class \code{matrix} or 
\code{data.frame} but must be conformable to a matrix of integers,
as verified by \code{\link{check_document_term_table}}.}

\item{topics}{Vector of the number of topics to evaluate for each model.
Must be conformable to \code{integer} values.}

\item{nseeds}{Number of seeds (replicate starts) to use for each 
value of \code{topics}. Must be conformable to \code{integer} value.}

\item{control}{A \code{list} of parameters to control the running and 
selecting of LDA models. Values not input assume default values set 
by \code{\link{LDA_set_control}}. Values for running the LDAs replace 
defaults in (\code{LDAcontol}, see \code{\link[topicmodels]{LDA}} (but if
 \code{seed} is given, it will be overwritten; use \code{iseed} instead).}
}
\value{
\code{LDA_set}: \code{list} (class: \code{LDA_set}) of LDA models 
  (class: \code{LDA_VEM}).
  \code{check_LDA_set_inputs}: an error message is thrown if any input is 
  improper, otherwise \code{NULL}.
}
\description{
For a given dataset consisting of counts of words across 
  multiple documents in a corpus, conduct multiple Latent Dirichlet 
  Allocation (LDA) models (using the Variational Expectation 
  Maximization (VEM) algorithm; Blei \emph{et al.} 2003) to account for [1]  
  uncertainty in the number of latent topics and [2] the impact of initial
  values in the estimation procedure. \cr \cr
  \code{LDA_set} is a list wrapper of \code{\link[topicmodels]{LDA}}
  in the \code{topicmodels} package (Grun and Hornik 2011). \cr \cr
  \code{check_LDA_set_inputs} checks that all of the inputs 
  are proper for \code{LDA_set} (that the table of observations is 
  conformable to a matrix of integers, the number of topics is an integer, 
  the number of seeds is an integer and the controls list is proper).
}
\examples{
  data(rodents)
  lda_data <- rodents$document_term_table
  r_LDA <- LDA_set(lda_data, topics = 2, nseeds = 2)                         

}
\references{
Blei, D. M., A. Y. Ng, and M. I. Jordan. 2003. Latent Dirichlet
  Allocation. \emph{Journal of Machine Learning Research} 
  \strong{3}:993-1022.
  \href{http://jmlr.csail.mit.edu/papers/v3/blei03a.html}{link}.

  Grun B. and K. Hornik. 2011. topicmodels: An R Package for Fitting Topic
  Models. \emph{Journal of Statistical Software} \strong{40}:13.
  \href{https://www.jstatsoft.org/article/view/v040i13}{link}.
}
