% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_LCF.R
\name{plot_LCF}
\alias{plot_LCF}
\title{Plot sample data, linear combination fit and residual spectrum}
\usage{
plot_LCF(all.samples, all.standards, LCF.res, LC.vals, corr.norm,
  float = NULL, exclude = NULL, use.tiff = NULL, E.zero = NULL,
  set.plot.ymax = NULL, file.output = NULL)
}
\arguments{
\item{all.samples}{List of all samples}

\item{all.standards}{List of all standards}

\item{LCF.res}{Results from function fit_float()}

\item{LC.vals}{The fitting range values for the linear combination fitting}

\item{corr.norm}{Vector of the base-line correction and edge-step normalization values (vector of length 4)}

\item{float}{Logical, default to FALSE}

\item{exclude}{Logical, default to FALSE}

\item{use.tiff}{Logical, default to FALSE}

\item{E.zero}{Set E0, defaults to NULL}

\item{set.plot.ymax}{Set maximum of plot y axis, defaults to NULL}

\item{file.output}{Logical, default to FALSE}
}
\description{
This function allows plotting (png or tiff image files) of the corrected sample spectrum, the linear combination fit and the residual.
}
\examples{
data(stdmix)
corr.spec.standards  <- initial_load(specdat[1:4], 
  corr.norm = c(-36, -15, 37, 58))
corr.spec.samples    <- initial_load(specdat[5:8], 
  corr.norm = c(-36, -15, 37, 58))
param.float <- expand.grid(pre.adj.1 = seq(-45,-30,5), 
  pre.adj.2 = seq(-19,-9,5), post.adj.1 = seq(34,40,2), 
  post.adj.2 = seq(50,65,5))
float.fit <- fit_float(all.samples = corr.spec.samples[1], 
  all.standards = corr.spec.standards, LC.vals = c(-14, 46), 
  float = param.float, ex.smaller = 0.05)
par(pty="s")
plot_LCF(all.samples = corr.spec.samples[1], 
  all.standards = corr.spec.standards, 
  LCF.res = float.fit[1,], LC.vals = c(-14,46), 
  corr.norm = c(-36, -15, 37, 58))
}
\keyword{LCF}
\keyword{plot,}

