% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{LBSPRopt}
\alias{LBSPRopt}
\title{Optimisation Routine for fitting LBSPR}
\usage{
LBSPRopt(trypars, yr = 1, LB_pars = NULL, LB_lengths = NULL,
  Control = list(), pen = TRUE)
}
\arguments{
\item{trypars}{a vector of exploitation parameters in log space}

\item{yr}{index of the year column to fit the model to}

\item{LB_pars}{an object of class \code{'LB_pars'} that contains the life history information}

\item{LB_lengths}{an object of class \code{'LB_lengths'} that contains the length data}

\item{Control}{a list of control options for the LBSPR model.}

\item{pen}{apply a penalty if estimate of selectivity is very high?}
}
\value{
a NLL value
}
\description{
A function that calculate the negative log-likelihood of the LBSPR model
}
\details{
The Control options are:
\describe{
 \item{\code{modtype}}{Model Type: either Growth-Type-Group Model (default: "GTG") or Age-Structured ("absel")}
 \item{\code{maxsd}}{Maximum number of standard deviations for length-at-age distribution (default is 2)}
 \item{\code{ngtg}}{Number of groups for the GTG model. Default is 13}
 \item{\code{P}}{Proportion of survival of initial cohort for maximum age for Age-Structured model. Default is 0.01}
 \item{\code{Nage}}{Number of pseudo-age classes in the Age Structured model. Default is 101}
 \item{\code{maxFM}}{Maximum value for F/M. Estimated values higher than this are trunctated to \code{maxFM}. Default is 4}
}
}
\author{
A. Hordyk
}

