/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.NounExtractor;

import java.util.LinkedList;
import kr.ac.kaist.swrc.jhannanum.comm.Eojeol;
import kr.ac.kaist.swrc.jhannanum.comm.Sentence;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.PosProcessor;

public class NounExtractor
implements PosProcessor {
    private LinkedList<String> nounMorphemes = null;
    private LinkedList<String> nounTags = null;

    @Override
    public void initialize(String baseDir, String configFile) throws Exception {
        this.nounMorphemes = new LinkedList();
        this.nounTags = new LinkedList();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Sentence doProcess(Sentence st) {
        Eojeol[] eojeols = st.getEojeols();
        int i = 0;
        while (i < eojeols.length) {
            String[] morphemes = eojeols[i].getMorphemes();
            String[] tags = eojeols[i].getTags();
            this.nounMorphemes.clear();
            this.nounTags.clear();
            int j = 0;
            while (j < tags.length) {
                char c = tags[j].charAt(0);
                if (c == 'n') {
                    this.nounMorphemes.add(morphemes[j]);
                    this.nounTags.add(tags[j]);
                } else if (c == 'f') {
                    this.nounMorphemes.add(morphemes[j]);
                    this.nounTags.add("ncn");
                }
                ++j;
            }
            eojeols[i].setMorphemes(this.nounMorphemes.toArray(new String[0]));
            eojeols[i].setTags(this.nounTags.toArray(new String[0]));
            ++i;
        }
        st.setEojeols(eojeols);
        return st;
    }
}

