/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.morph;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.CompoundEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSOutput
implements Cloneable {
    private int lastStart = 0;
    private int lastEnd = 0;
    private List<AnalysisOutput> phrases = new ArrayList<AnalysisOutput>();

    public WSOutput() {
    }

    public WSOutput(AnalysisOutput o) {
        this.addPhrase(o);
    }

    public int getLastStart() {
        return this.lastStart;
    }

    public void setLastStart(int start) {
        this.lastStart = start;
    }

    public int getLastEnd() {
        return this.lastEnd;
    }

    public void setLastEnd(int end) {
        this.lastStart = end;
    }

    public List<AnalysisOutput> getPhrases() {
        return this.phrases;
    }

    public void removeLast() {
        if (this.phrases.size() == 0) {
            return;
        }
        AnalysisOutput o = this.phrases.remove(this.phrases.size() - 1);
        if (this.phrases.size() == 0) {
            this.lastStart = 0;
            this.lastEnd = 0;
        } else {
            this.lastEnd -= o.getSource().length();
            if (this.phrases.size() > 1) {
                AnalysisOutput o1 = this.phrases.get(this.phrases.size() - 1);
                this.lastStart = this.lastEnd - o1.getSource().length();
            } else {
                this.lastStart = 0;
            }
        }
    }

    public void addPhrase(AnalysisOutput o) {
        this.lastStart = this.lastEnd;
        this.lastEnd += o.getSource().length();
        if (o.getCNounList().size() == 0) {
            this.phrases.add(o);
        } else {
            this.addCompounds(o);
        }
    }

    private void addCompounds(AnalysisOutput o) {
        List<CompoundEntry> cnouns = o.getCNounList();
        String source = o.getSource();
        boolean rmstemlen = false;
        int i = 0;
        while (i < cnouns.size() - 1) {
            String noun = cnouns.get(i).getWord();
            boolean isOnechar = false;
            if (cnouns.get(i).getWord().length() == 1 || cnouns.get(i + 1).getWord().length() == 1) {
                noun = String.valueOf(noun) + cnouns.get(i + 1).getWord();
                isOnechar = true;
            }
            if (isOnechar && i >= cnouns.size() - 2) break;
            int score = 100;
            if (!cnouns.get(i).isExist()) {
                score = 10;
            }
            AnalysisOutput o1 = new AnalysisOutput(noun, null, null, 'N', 1, score);
            o1.setSource(noun);
            if (isOnechar) {
                o1.addCNoun(cnouns.get(i));
                o1.addCNoun(cnouns.get(i + 1));
            }
            if (source.length() > noun.length()) {
                source = source.substring(noun.length());
            }
            this.phrases.add(o1);
            cnouns.remove(cnouns.get(0));
            --i;
            if (isOnechar) {
                cnouns.remove(cnouns.get(0));
            }
            ++i;
        }
        o.setStem(o.getStem().substring(o.getSource().length() - source.length()));
        o.setSource(source);
        if (cnouns.size() == 1) {
            cnouns.remove(0);
        }
        this.phrases.add(o);
    }

    public void setPhrases(List<AnalysisOutput> phrases) {
        this.phrases = phrases;
    }

    public WSOutput clone() throws CloneNotSupportedException {
        WSOutput candidate = (WSOutput)super.clone();
        candidate.setLastStart(this.lastStart);
        candidate.setLastEnd(this.lastEnd);
        ArrayList<AnalysisOutput> list = new ArrayList<AnalysisOutput>();
        list.addAll(this.phrases);
        candidate.setPhrases(list);
        return candidate;
    }
}

