/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.AnalysisOutput;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.utils.DictionaryUtil;
import org.apache.lucene.analysis.kr.utils.MorphUtil;
import org.apache.lucene.analysis.kr.utils.SyllableUtil;

public class EomiUtil {
    public static final String RESULT_FAIL = "0";
    public static final String RESULT_SUCCESS = "1";
    public static final String[] verbSuffix = new String[]{"\uc774", "\ud558", "\ub418", "\uc2a4\ub7fd", "\uc2a4\ub7ec\uc6b0", "\uc2dc\ud0a4", "\uc788", "\uc5c6", "\uac19", "\ub2f9\ud558", "\ub9cc\ud558", "\ub4dc\ub9ac", "\ubc1b"};

    public static String[] longestEomi(String term) throws MorphException {
        String[] result = new String[2];
        result[0] = term;
        int i = term.length();
        while (i > 0) {
            char[] efeature;
            String eomi;
            String stem = term.substring(0, i);
            if (i != term.length()) {
                eomi = term.substring(i);
                efeature = SyllableUtil.getFeature(eomi.charAt(0));
            } else {
                efeature = SyllableUtil.getFeature(stem.charAt(i - 1));
                eomi = "";
            }
            if (SyllableUtil.isAlpanumeric(stem.charAt(i - 1))) break;
            char[] jasos = MorphUtil.decompose(stem.charAt(i - 1));
            if ("".equals(eomi) || DictionaryUtil.existEomi(eomi)) {
                if (jasos.length > 2 && (jasos[2] == '\u3134' || jasos[2] == '\u3139' || jasos[2] == '\u3141' || jasos[2] == '\u3142') && DictionaryUtil.combineAndEomiCheck(jasos[2], eomi) != null) {
                    result[0] = Character.toString(MorphUtil.makeChar(stem.charAt(i - 1), 0));
                    if (i != 0) {
                        result[0] = String.valueOf(stem.substring(0, i - 1)) + result[0];
                    }
                    result[1] = Character.toString(jasos[2]);
                } else if (i > 0 && stem.endsWith("\ud558") && "\uc5ec".equals(eomi) || stem.endsWith("\uac00") && "\uac70\ub77c".equals(eomi) || stem.endsWith("\uc624") && "\ub108\ub77c".equals(eomi)) {
                    result[0] = stem;
                    result[1] = eomi;
                } else if (!(jasos.length != 2 || stem.endsWith("\uc544") || stem.endsWith("\uc5b4") || jasos[1] != '\u314f' && jasos[1] != '\u3153' && jasos[1] != '\u3154' && jasos[1] != '\u3150' || DictionaryUtil.combineAndEomiCheck('\uc5b4', eomi) == null)) {
                    char[] chs = MorphUtil.decompose(stem.charAt(stem.length() - 1));
                    result[0] = stem;
                    result[1] = "\uc5b4" + eomi;
                } else if ((jasos[1] == '\u3158' || jasos[1] == '\u315d' || jasos[1] == '\u3155' || jasos[1] == '\u3150' || jasos[1] == '\u3152') && DictionaryUtil.combineAndEomiCheck('\uc5b4', eomi) != null) {
                    String end = "";
                    if (jasos[1] == '\u3158') {
                        end = String.valueOf(MorphUtil.makeChar(stem.charAt(i - 1), 8, 0)) + "\uc544";
                    } else if (jasos[1] == '\u315d') {
                        end = String.valueOf(MorphUtil.makeChar(stem.charAt(i - 1), 13, 0)) + "\uc5b4";
                    } else if (jasos[1] == '\u3155') {
                        end = Character.toString(MorphUtil.makeChar(stem.charAt(i - 1), 6, 0));
                    } else if (jasos[1] == '\u3150') {
                        end = String.valueOf(MorphUtil.makeChar(stem.charAt(i - 1), 0, 0)) + "\uc5b4";
                    } else if (jasos[1] == '\u3152') {
                        end = String.valueOf(MorphUtil.makeChar(stem.charAt(i - 1), 20, 0)) + "\uc560";
                    }
                    if (jasos.length == 3) {
                        end = String.valueOf(end.substring(0, end.length() - 1)) + MorphUtil.replaceJongsung(end.charAt(end.length() - 1), stem.charAt(i - 1));
                    }
                    result[0] = stem.length() < 2 ? end : String.valueOf(stem.substring(0, stem.length() - 1)) + end;
                    result[1] = eomi;
                } else if (!(efeature == null || efeature[SyllableUtil.IDX_EOMI1] == '0' || !DictionaryUtil.existEomi(eomi) || (jasos.length == 2 && jasos[0] == '\u3139' || jasos.length == 3 && jasos[2] == '\u3139') && eomi.equals("\ub7ec"))) {
                    result[0] = stem;
                    result[1] = eomi;
                }
            }
            if (efeature != null && efeature[SyllableUtil.IDX_EOMI2] == '0') break;
            --i;
        }
        return result;
    }

    public static String[] splitPomi(String stem) throws MorphException {
        String[] results = new String[2];
        results[0] = stem;
        if (stem == null || stem.length() == 0 || "\uc788".equals(stem)) {
            return results;
        }
        char[] chrs = stem.toCharArray();
        int len = chrs.length;
        String pomi = "";
        int index = len - 1;
        char[] jaso = MorphUtil.decompose(chrs[index]);
        if (chrs[index] != '\uc2dc' && chrs[index] != '\u3146' && jaso[jaso.length - 1] != '\u3146') {
            return results;
        }
        if (chrs[index] == '\uaca0') {
            pomi = "\uaca0";
            EomiUtil.setPomiResult(results, stem.substring(0, index), pomi);
            if (--index <= 0 || chrs[index] != '\uc2dc' && chrs[index] != '\u3146' && jaso[jaso.length - 1] != '\u3146') {
                return results;
            }
            jaso = MorphUtil.decompose(chrs[index]);
        }
        if (chrs[index] == '\uc5c8') {
            pomi = String.valueOf(chrs[index]) + pomi;
            EomiUtil.setPomiResult(results, stem.substring(0, index), pomi);
            if (--index <= 0 || chrs[index] != '\uc2dc' && chrs[index] != '\u3146' && jaso[jaso.length - 1] != '\u3146') {
                return results;
            }
            jaso = MorphUtil.decompose(chrs[index]);
        }
        if (chrs[index] == '\uc600') {
            pomi = String.valueOf(MorphUtil.replaceJongsung('\uc5b4', chrs[index])) + pomi;
            stem = index > 0 && chrs[index - 1] == '\ud558' ? stem.substring(0, index) : String.valueOf(stem.substring(0, index)) + "\uc774";
            EomiUtil.setPomiResult(results, stem, pomi);
        } else if (chrs[index] == '\uc168') {
            pomi = String.valueOf(MorphUtil.replaceJongsung('\uc5b4', chrs[index])) + pomi;
            stem = stem.substring(0, index);
            EomiUtil.setPomiResult(results, stem, "\uc2dc" + pomi);
        } else if (chrs[index] == '\uc558' || chrs[index] == '\uc5c8') {
            pomi = String.valueOf(chrs[index]) + pomi;
            EomiUtil.setPomiResult(results, stem.substring(0, index), pomi);
            if (--index <= 0 || chrs[index] != '\uc2dc' && chrs[index] != '\uc73c') {
                return results;
            }
            jaso = MorphUtil.decompose(chrs[index]);
        } else if (jaso.length == 3 && jaso[2] == '\u3146') {
            if (jaso[0] == '\u314e' && jaso[1] == '\u3150') {
                pomi = String.valueOf(MorphUtil.replaceJongsung('\uc5b4', chrs[index])) + pomi;
                stem = String.valueOf(stem.substring(0, index)) + "\ud558";
            } else if (jaso[0] != '\u3147' && (jaso[1] == '\u314f' || jaso[1] == '\u3153' || jaso[1] == '\u3154' || jaso[1] == '\u3150')) {
                pomi = "\uc5c8" + pomi;
                stem = String.valueOf(stem.substring(0, index)) + MorphUtil.makeChar(chrs[index], 0);
            } else if (jaso[0] != '\u3147' && jaso[1] == '\u3159') {
                pomi = "\uc5c8" + pomi;
                stem = String.valueOf(stem.substring(0, index)) + MorphUtil.makeChar(chrs[index], 11, 0);
            } else if (jaso[1] == '\u3158') {
                pomi = String.valueOf(MorphUtil.replaceJongsung('\uc544', chrs[index])) + pomi;
                stem = String.valueOf(stem.substring(0, index)) + MorphUtil.makeChar(chrs[index], 8, 0);
            } else if (jaso[1] == '\u315d') {
                pomi = String.valueOf(MorphUtil.replaceJongsung('\uc5b4', chrs[index])) + pomi;
                stem = String.valueOf(stem.substring(0, index)) + MorphUtil.makeChar(chrs[index], 13, 0);
            } else if (jaso[1] == '\u3155') {
                pomi = String.valueOf(MorphUtil.replaceJongsung('\uc5b4', chrs[index])) + pomi;
                stem = String.valueOf(stem.substring(0, index)) + MorphUtil.makeChar(chrs[index], 20, 0);
            } else if (jaso[1] == '\u3150') {
                pomi = String.valueOf(MorphUtil.replaceJongsung('\uc5b4', chrs[index])) + pomi;
                stem = stem.substring(0, index);
            } else if (jaso[1] == '\u3152') {
                pomi = String.valueOf(MorphUtil.replaceJongsung('\uc560', chrs[index])) + pomi;
                stem = stem.substring(0, index);
            } else {
                pomi = "\uc5c8" + pomi;
            }
            EomiUtil.setPomiResult(results, stem, pomi);
            if (chrs[index] != '\uc2dc' && chrs[index] != '\uc73c') {
                return results;
            }
            jaso = MorphUtil.decompose(chrs[index]);
        }
        char[] nChrs = null;
        nChrs = index > 0 ? MorphUtil.decompose(chrs[index - 1]) : new char[2];
        if (nChrs.length == 2 && chrs[index] == '\uc2dc' && (chrs.length <= index + 1 || chrs.length > index + 1 && chrs[index + 1] != '\uc168')) {
            if (DictionaryUtil.getWord(results[0]) != null) {
                return results;
            }
            pomi = String.valueOf(chrs[index]) + pomi;
            EomiUtil.setPomiResult(results, stem.substring(0, index), pomi);
            if (--index == 0 || chrs[index] != '\uc73c') {
                return results;
            }
            jaso = MorphUtil.decompose(chrs[index]);
        }
        nChrs = index > 0 ? MorphUtil.decompose(chrs[index - 1]) : new char[2];
        if (chrs.length > index + 1 && nChrs.length == 3 && (chrs[index + 1] == '\uc168' || chrs[index + 1] == '\uc2dc') && chrs[index] == '\uc73c') {
            pomi = String.valueOf(chrs[index]) + pomi;
            EomiUtil.setPomiResult(results, stem.substring(0, index), pomi);
        }
        return results;
    }

    public static List irregular(AnalysisOutput output) throws MorphException {
        ArrayList<AnalysisOutput> results = new ArrayList<AnalysisOutput>();
        if (output.getStem() == null || output.getStem().length() == 0) {
            return results;
        }
        String ending = output.getEomi();
        if (output.getPomi() != null) {
            ending = output.getPomi();
        }
        ArrayList irrs = new ArrayList();
        EomiUtil.irregularStem(irrs, output.getStem(), ending);
        EomiUtil.irregularEnding(irrs, output.getStem(), ending);
        EomiUtil.irregularAO(irrs, output.getStem(), ending);
        try {
            for (String[] irr : irrs) {
                AnalysisOutput result = output.clone();
                result.setStem(irr[0]);
                if (output.getPatn() == 11) {
                    if (output.getPomi() == null) {
                        result.setEomi(irr[1]);
                    } else {
                        result.setPomi(irr[1]);
                    }
                }
                results.add(result);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new MorphException(e.getMessage(), e);
        }
        return results;
    }

    private static void irregularStem(List results, String stem, String ending) {
        char feCh = ending.charAt(0);
        char[] fechJaso = MorphUtil.decompose(feCh);
        char ls = stem.charAt(stem.length() - 1);
        char[] lsJaso = MorphUtil.decompose(ls);
        if (feCh == '\uc544' || feCh == '\uc5b4' || feCh == '\uc73c') {
            if (lsJaso[lsJaso.length - 1] == '\u3139') {
                results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 7), ending, String.valueOf('d')});
            } else if (lsJaso.length == 2) {
                results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 19), ending, String.valueOf('s')});
            }
        }
        if ((fechJaso[0] == '\u3134' || fechJaso[0] == '\u3139' || fechJaso[0] == '\u3141' || feCh == '\uc624' || feCh == '\uc2dc') && ls == '\uc6b0') {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 17), ending, String.valueOf('b')});
        }
        if ((fechJaso[0] == '\u3134' || fechJaso[0] == '\u3142' || fechJaso[0] == '\u3145' || feCh == '\uc624') && lsJaso.length == 2) {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 8), ending, String.valueOf('L')});
        }
        if (!(lsJaso.length != 2 || fechJaso[0] != '\u3134' && fechJaso[0] != '\u3139' && fechJaso[0] != '\u3141' && fechJaso[0] != '\u3142' && lsJaso[1] != '\u314f' && lsJaso[1] != '\u3153' && lsJaso[1] != '\u3151' && lsJaso[1] != '\u3155' || "\ub098".equals(stem))) {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 27), ending, String.valueOf('h')});
        }
    }

    private static void irregularEnding(List results, String stem, String ending) {
        if (ending.startsWith("\u3146")) {
            return;
        }
        char feCh = ending.charAt(0);
        char ls = stem.charAt(stem.length() - 1);
        if (feCh == '\ub7ec' && ls == '\ub974') {
            results.add(new String[]{stem, "\uc5b4" + ending.substring(1), String.valueOf('r')});
        } else if ("\ub77c".equals(ending) && "\uac00\uac70".equals(stem)) {
            results.add(new String[]{stem.substring(0, stem.length() - 1), "\uc5b4\ub77c", String.valueOf('g')});
        } else if ("\ub77c".equals(ending) && "\uc624\ub108".equals(stem)) {
            results.add(new String[]{stem.substring(0, stem.length() - 1), "\uc5b4\ub77c", String.valueOf('n')});
        }
        if ("\uc5ec".equals(ending) && ls == '\ud558') {
            results.add(new String[]{stem, "\uc5b4", String.valueOf('n')});
        }
    }

    private static void irregularAO(List results, String stem, String ending) {
        char ls = stem.charAt(stem.length() - 1);
        char[] lsJaso = MorphUtil.decompose(ls);
        if (lsJaso.length < 2) {
            return;
        }
        if (lsJaso[1] == '\u3158') {
            if (stem.endsWith("\ub3c4\uc640") || stem.endsWith("\uace0\uc640")) {
                results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 2)) + MorphUtil.makeChar(stem.charAt(stem.length() - 2), 17), EomiUtil.makeTesnseEomi("\uc544", ending), String.valueOf('b')});
            } else {
                results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 8, 0), EomiUtil.makeTesnseEomi("\uc544", ending), String.valueOf('w')});
            }
        } else if (stem.endsWith("\ud37c")) {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 18, 0), EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('w')});
        } else if (lsJaso[1] == '\u315d') {
            if (stem.length() >= 2) {
                results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 2)) + MorphUtil.makeChar(stem.charAt(stem.length() - 2), 17), EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('b')});
            }
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 13, 0), EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('w')});
        } else if (stem.length() >= 2 && ls == '\ub77c') {
            char[] ns = MorphUtil.decompose(stem.charAt(stem.length() - 2));
            if (ns.length == 3 && ns[2] == '\u3139') {
                results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 2)) + MorphUtil.makeChar(stem.charAt(stem.length() - 2), 0) + "\ub974", EomiUtil.makeTesnseEomi("\uc544", ending), String.valueOf('r')});
            }
        } else if (stem.length() >= 2 && ls == '\ub7ec') {
            char[] ns = MorphUtil.decompose(stem.charAt(stem.length() - 2));
            if (stem.charAt(stem.length() - 2) == '\ub974') {
                results.add(new String[]{stem.substring(0, stem.length() - 1), EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('l')});
            } else if (ns.length == 3 && ns[2] == '\u3139') {
                results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 2)) + MorphUtil.makeChar(stem.charAt(stem.length() - 2), 0) + "\ub974", EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('r')});
            }
        } else if (stem.endsWith("\ud3b4") || stem.endsWith("\ucf1c")) {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 20, 0), EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('e')});
        } else if (stem.endsWith("\ud574")) {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 0, 0), EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('e')});
        } else if (lsJaso.length == 2 && lsJaso[1] == '\u314f') {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 18, 0), EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('u')});
        } else if (lsJaso.length == 2 && lsJaso[1] == '\u3153') {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 18, 0), EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('u')});
            results.add(new String[]{stem, EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('a')});
        } else if (lsJaso[1] == '\u3155') {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 20, 0), EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('e')});
        } else if (lsJaso[1] == '\u3159') {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 11, 0), EomiUtil.makeTesnseEomi("\uc5b4", ending), String.valueOf('O')});
        } else if (lsJaso[1] == '\u3150') {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 0, 27), EomiUtil.makeTesnseEomi("\uc544", ending), String.valueOf('h')});
        } else if (lsJaso[1] == '\u3152') {
            results.add(new String[]{String.valueOf(stem.substring(0, stem.length() - 1)) + MorphUtil.makeChar(stem.charAt(stem.length() - 1), 2, 27), EomiUtil.makeTesnseEomi("\uc544", ending), String.valueOf('h')});
        }
    }

    public static String makeTesnseEomi(String preword, String endword) {
        if (preword == null || preword.length() == 0) {
            return endword;
        }
        if (endword == null || endword.length() == 0) {
            return preword;
        }
        if (endword.charAt(0) == '\u3146') {
            return String.valueOf(preword.substring(0, preword.length() - 1)) + MorphUtil.makeChar(preword.charAt(preword.length() - 1), 20) + endword.substring(1, endword.length());
        }
        if (endword.charAt(0) == '\u3134') {
            return String.valueOf(preword.substring(0, preword.length() - 1)) + MorphUtil.makeChar(preword.charAt(preword.length() - 1), 4) + endword.substring(1, endword.length());
        }
        if (endword.charAt(0) == '\u3139') {
            return String.valueOf(preword.substring(0, preword.length() - 1)) + MorphUtil.makeChar(preword.charAt(preword.length() - 1), 8) + endword.substring(1, endword.length());
        }
        if (endword.charAt(0) == '\u3141') {
            return String.valueOf(preword.substring(0, preword.length() - 1)) + MorphUtil.makeChar(preword.charAt(preword.length() - 1), 16) + endword.substring(1, endword.length());
        }
        if (endword.charAt(0) == '\u3142') {
            return String.valueOf(preword.substring(0, preword.length() - 1)) + MorphUtil.makeChar(preword.charAt(preword.length() - 1), 17) + endword.substring(1, endword.length());
        }
        return String.valueOf(preword) + endword;
    }

    public static boolean hasVerbSuffix(String stem) {
        int i = 0;
        while (i < verbSuffix.length) {
            if (stem.endsWith(verbSuffix[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isVerbSuffix(String stem) {
        int i = 0;
        while (i < verbSuffix.length) {
            if (stem.equals(verbSuffix[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean endsWithEEomi(String stem) {
        int len = stem.length();
        if (len < 2 || !stem.endsWith("\uc774")) {
            return false;
        }
        char[] jasos = MorphUtil.decompose(stem.charAt(len - 2));
        if (jasos.length == 3 && jasos[2] == '\u3141') {
            return true;
        }
        int index = stem.lastIndexOf("\uae30");
        if (index == -1) {
            index = stem.lastIndexOf("\uc5d0\uc11c");
        }
        if (index == -1) {
            index = stem.lastIndexOf("\ubd80\ud130");
        }
        return index != -1;
    }

    private static void setPomiResult(String[] results, String stem, String pomi) {
        results[0] = stem;
        results[1] = pomi;
    }

    public static boolean IsNLMBSyl(char ech, char lch) throws MorphException {
        char[] features = SyllableUtil.getFeature(ech);
        switch (lch) {
            case '\u3134': {
                return features[SyllableUtil.IDX_YNPNA] == '1';
            }
            case '\u3139': {
                return features[SyllableUtil.IDX_YNPLA] == '1';
            }
            case '\u3141': {
                return features[SyllableUtil.IDX_YNPMA] == '1';
            }
            case '\u3142': {
                return features[SyllableUtil.IDX_YNPBA] == '1';
            }
        }
        return false;
    }

    public static String[] splitEomi(String stem, String end) throws MorphException {
        String[] strs = new String[2];
        int strlen = stem.length();
        if (strlen == 0) {
            return strs;
        }
        char estem = stem.charAt(strlen - 1);
        char[] chrs = MorphUtil.decompose(estem);
        if (chrs.length == 1) {
            return strs;
        }
        if (chrs.length == 3 && (chrs[2] == '\u3134' || chrs[2] == '\u3139' || chrs[2] == '\u3141' || chrs[2] == '\u3142') && EomiUtil.IsNLMBSyl(estem, chrs[2]) && DictionaryUtil.combineAndEomiCheck(chrs[2], end) != null) {
            strs[1] = Character.toString(chrs[2]);
            if (end.length() > 0) {
                strs[1] = String.valueOf(strs[1]) + end;
            }
            strs[0] = String.valueOf(stem.substring(0, strlen - 1)) + MorphUtil.makeChar(estem, 0);
        } else if (estem == '\ud574' && DictionaryUtil.existEomi("\uc5b4" + end)) {
            strs[0] = String.valueOf(stem.substring(0, strlen - 1)) + "\ud558";
            strs[1] = "\uc5b4" + end;
        } else if (estem == '\ud788' && DictionaryUtil.existEomi("\uc774" + end)) {
            strs[0] = String.valueOf(stem.substring(0, strlen - 1)) + "\ud558";
            strs[1] = "\uc774" + end;
        } else if (!(chrs[0] == '\u3147' || chrs[1] != '\u314f' && chrs[1] != '\u3153' && chrs[1] != '\u3154' && chrs[1] != '\u3150' || chrs.length != 2 && SyllableUtil.getFeature(estem)[SyllableUtil.IDX_YNPAH] != '1' || DictionaryUtil.combineAndEomiCheck('\uc5b4', end) == null)) {
            strs[0] = stem;
            strs[1] = chrs.length == 2 ? "\uc5b4" + end : end;
        } else if (stem.endsWith("\ud558") && "\uc5ec".equals(end)) {
            strs[0] = stem;
            strs[1] = "\uc5b4";
        } else if (chrs.length == 2 && (chrs[1] == '\u3158' || chrs[1] == '\u3159' || chrs[1] == '\u315d' || chrs[1] == '\u3155' || chrs[1] == '\u3150' || chrs[1] == '\u3152') && DictionaryUtil.combineAndEomiCheck('\uc5b4', end) != null) {
            StringBuffer sb = new StringBuffer();
            if (strlen > 1) {
                sb.append(stem.substring(0, strlen - 1));
            }
            if (chrs[1] == '\u3158') {
                sb.append(MorphUtil.makeChar(estem, 8, 0)).append(MorphUtil.replaceJongsung('\uc544', estem));
            } else if (chrs[1] == '\u315d') {
                sb.append(MorphUtil.makeChar(estem, 13, 0)).append(MorphUtil.replaceJongsung('\uc5b4', estem));
            } else if (chrs[1] == '\u3159') {
                sb.append(MorphUtil.makeChar(estem, 11, 0)).append(MorphUtil.replaceJongsung('\uc5b4', estem));
            } else if (chrs[1] == '\u3155') {
                sb.append(Character.toString(MorphUtil.makeChar(estem, 20, 0))).append(MorphUtil.replaceJongsung('\uc5b4', estem));
            } else if (chrs[1] == '\u3150') {
                sb.append(MorphUtil.makeChar(estem, 0, 0)).append(MorphUtil.replaceJongsung('\uc5b4', estem));
            } else if (chrs[1] == '\u3152') {
                sb.append(MorphUtil.makeChar(estem, 20, 0)).append(MorphUtil.replaceJongsung('\uc560', estem));
            }
            strs[0] = sb.toString();
            end = String.valueOf(strs[0].substring(strs[0].length() - 1)) + end;
            strs[0] = strs[0].substring(0, strs[0].length() - 1);
            strs[1] = end;
        } else if (!"".equals(end) && DictionaryUtil.existEomi(end)) {
            strs = new String[]{stem, end};
        }
        return strs;
    }
}

