% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_PRE.R
\name{test_PRE}
\alias{test_PRE}
\title{Compute PRE and test it using the F-test.}
\usage{
test_PRE(
  fitC = NULL,
  fitA = NULL,
  n = NULL,
  PC = NULL,
  PA = NULL,
  SSEC = NULL,
  SSEA = NULL
)
}
\arguments{
\item{fitC}{The result of \code{lm()} of the Compact model (Model C).}

\item{fitA}{The result of \code{lm()} of the Augmented model (Model A).}

\item{n}{Sample size of the Model C or Model A. Model C and Model A must use the same sample, and hence have the same sample size.}

\item{PC}{The number of parameters in Model C.}

\item{PA}{The number of parameters in Model A. PA must be larger than PC.}

\item{SSEC}{The Sum of Squared Errors of Model C.}

\item{SSEA}{The Sum of Squared Errors of Model A.}
}
\value{
A data.frame including \emph{SSEC}, \emph{SSEA}, \emph{PRE}, \emph{F}, \emph{df1}, \emph{df2}, and \emph{p}.
}
\description{
Compute PRE and test it using the F-test.
}
\details{
\code{test_PRE()} tests the \code{PRE} (Proportional Reduction in Error) of Model A compared with Model C. There are two ways of using \code{test_PRE()}. The first is giving \code{test_PRE()} fitC and fitA. The second is giving \emph{n}, \emph{PC}, \emph{PA}, \emph{SSEC}, and \emph{SSEA}. The first way is more convenient, and it minimizes precision loss by omitting copying and pasting SSEC and SSEA. Please refer to Judd et al. (2017) for more details about \emph{PRE}.
}
\examples{
x <- rnorm(193)
y <- 0.3 + 0.2*x + rnorm(193)
dat <- data.frame(y, x)
fitC <- lm(y ~ 1, dat)
fitA <- lm(y ~ x, dat)
test_PRE(fitC, fitA)
}
\references{
Judd, C. M., McClelland, G. H., & Ryan, C. S. (2017). \emph{Data analysis: A model comparison approach to regression, ANOVA, and beyond}. Routledge.
}
