% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.3views.R
\name{plot3views}
\alias{plot3views}
\title{Create scatter plots in three views.}
\usage{
plot3views(X, labels, col.pat.table = NA, only.row = NA)
}
\arguments{
\item{X}{A matrix or a data.frame that contains at least 3 columns of numeric
data. If there are more than 3 columns in X, only the first 3 columns will be
used.}

\item{labels}{A vector containing row labels of X for display. All vector
elements should be of type "character" (as.character). The length of
vector equals the number of rows in X.}

\item{col.pat.table}{A data.frame that associates colors and patterns to row
labels (see labels before). It needs to contain 3 columns which represent
unique labels (column 1) and associated patterns (column 2) and colors
(column 3). Default = NA.}

\item{only.row}{A vector that contains subset of row numbers that are
selected to be plotted. Default = NA.}
}
\description{
Visualize data in X-Y plane, X-Z plane, and Y-Z
plane. The input object (matrix or data.frame) must contain at least 3
columns.
}
\details{
col.pat.table needs to be set properly. For example, given the
vector labels consists of 5 elements as in c('pop1','pop2','pop2','pop2',
'pop1'), the data.frame col.pat.table must contain 2 rows corresponding to
'pop1' and 'pop2', and 3 columns to describe their characteristics (i.e.
patterns and colors). See the section "Examples" for more details.
}
\examples{

#Load simulated dataset
data(example_SNP)

PCs <- cal.pc.linear(simsnp$snp, no.pc = 3)
plot3views( PCs$PC, sample_labels)

#To change colors and patterns using symbols
all.labels <- unique(sample_labels)
my.colors <- c('pink', 'yellow', 'cyan', 'green')
my.patterns<- c(0,1,2,3)
my.table <- data.frame(all.labels, my.patterns, my.colors)
plot3views(PCs$PC, labels = sample_labels, col.pat.table = my.table)

#To change colors and patterns using characters
my.patterns<- c('o', 'x', '&', '#')
#Use cbind to keep my.patterns as 'character'
my.table <- cbind(all.labels, my.patterns, my.colors)
plot3views(PCs$PC, labels = sample_labels, col.pat.table = my.table)
}
