% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KPC.R
\name{TnKnn}
\alias{TnKnn}
\title{Tn with geometric graphs}
\usage{
TnKnn(Y, X, k, Knn = 1)
}
\arguments{
\item{Y}{a matrix of response (n by dy)}

\item{X}{a matrix of predictors (n by dx)}

\item{k}{a function \eqn{k(y, y')} of class \code{kernel}. It can be the kernel implemented in \code{kernlab} e.g. Gaussian kernel: \code{rbfdot(sigma = 1)}, linear kernel: \code{vanilladot()}.}

\item{Knn}{the number of K-nearest neighbor to use; or "MST".}
}
\value{
The algorithm returns a real number which is the value of Tn.
}
\description{
Calculate \eqn{T_n} using directed K-NN graph or minimum spanning tree (MST).
}
\details{
\eqn{T_n} is an estimate of \eqn{E[E[k(Y_1,Y_1')|X]]}, with \eqn{Y_1}, \eqn{Y_1'} drawn iid from \eqn{Y|X}, given \eqn{X}.
For K-NN graph, ties will be broken at random. Algorithm finding the MST is implemented the package \code{emstreeR}.
}
