% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.KFS.R
\name{coef.SSModel}
\alias{coef.KFS}
\alias{coef.SSModel}
\title{Smoothed Estimates or One-step-ahead Predictions of States}
\usage{
\method{coef}{KFS}(object, start = NULL, end = NULL, filtered = FALSE,
  states = "all", last = FALSE, ...)

\method{coef}{SSModel}(object, start = NULL, end = NULL, filtered = FALSE,
  states = "all", last = FALSE, nsim = 0, ...)
}
\arguments{
\item{object}{An object of class \code{KFS} or \code{SSModel}.}

\item{start}{The start time of the period of interest. Defaults to first time
point of the object.}

\item{end}{The end time of the period of interest. Defaults to the last time
point of the object.}

\item{filtered}{Logical, return filtered instead of smoothed estimates of
state vector. Default is \code{FALSE}.}

\item{states}{Which states to extract? Either a numeric vector containing
the indices of the corresponding states, or a character vector defining the
types of the corresponding states. Possible choices are
 \code{"all"},  \code{"level"}, \code{"slope"},
 \code{"trend"},  \code{"regression"}, \code{"arima"}, \code{"custom"},
 \code{"cycle"} or \code{"seasonal"}, where \code{"trend"} extracts all states
 relating to trend. These can be combined. Default is \code{"all"}.}

\item{last}{If \code{TRUE}, extract only the last time point as numeric vector
(ignoring \code{start} and \code{end}). Default is \code{FALSE}.}

\item{nsim}{Only for method for for non-Gaussian model of class \code{SSModel}.
The number of independent samples used in importance sampling.
Default is 0, which computes the
approximating Gaussian model by \code{\link{approxSSM}} and performs the
usual Gaussian filtering/smoothing so that the smoothed state estimates
equals to the conditional mode of \eqn{p(\alpha_t|y)}{p(\alpha[t]|y)}.
In case of \code{nsim = 0}, the mean estimates and their variances are computed using
the Delta method (ignoring the covariance terms).}

\item{\dots}{Additional arguments to \code{\link{KFS}}.
Ignored in method for object of class \code{KFS}.}
}
\value{
Multivariate time series containing estimates states.
}
\description{
Compute smoothed estimates or one-step-ahead predictions of states of
\code{SSModel} object or extract them from output of \code{KFS}.
For non-Gaussian models without simulation (\code{nsim = 0}),
these are the estimates of conditional modes of
states. For Gaussian models and non-Gaussian models with importance sampling,
these are the estimates of conditional means of states.
}
\examples{

model <- SSModel(log(drivers) ~ SSMtrend(1, Q = list(1)) +
 SSMseasonal(period = 12, sea.type = "trigonometric") +
 log(PetrolPrice) + law, data = Seatbelts, H = 1)

coef(model, states = "regression", last = TRUE)
coef(model, start = c(1983, 12), end = c(1984, 2))
out <- KFS(model)
coef(out, states = "regression", last = TRUE)
coef(out, start = c(1983, 12), end = c(1984, 2))

}

