% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testsim.R
\name{SVJ}
\alias{SVJ}
\title{SVJ model with one factor simulation}
\usage{
SVJ(M, m, p0 = 3, lambda = 0.2, mu = 0.05, v0 = 0, b = 0.2,
  alpha = 0.015, sigma = 0.05, sigma1 = 1)
}
\arguments{
\item{M}{number of interverals to be simulated}

\item{m}{number of time points within each interval}

\item{p0}{start price}

\item{lambda}{frequency of jump}

\item{mu}{drift}

\item{v0}{starting volatility}

\item{b}{volatility parameter}

\item{alpha}{volatility parameter}

\item{sigma}{volatility parameter}

\item{sigma1}{jump size parameter}
}
\value{
simulated time series
}
\description{
Simulate stochastic volatility model (with jump) with given length and other parameters
}
\examples{
SVJ(390,1200)
}
\references{
Yen, Y.-M. (2013). "Testing Jumps via False Discovery Rate Control." PloS one 8(4): e58365.
}
