% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testsim.R
\name{ppool}
\alias{ppool}
\title{p-values pooling and adjustment}
\usage{
ppool(pmat, method = "SD")
}
\arguments{
\item{pmat}{p-values matrix stored by columns}

\item{method}{pooling methods, see details}
}
\value{
\item{stat}{pooled test statistcs}

\item{pvalue}{pooled p-values}

\item{adjp}{pooled p-values via "BH" adjustments}
}
\description{
Pooling input p-values and perfrom FDR adjustments
}
\details{
for p-values poolings, we provided six methods. "FI" for Fisher's method, "FD" for Fisher's with correlation adjustments, "SI" for Stouffer's method, "SD" for Stouffer's method with correlation adjustments, "MI" for minimum p-value methods, and "MA" for maximum p-value method
}
\examples{
orip <- matrix(runif(3000),1000,3)
pvobj <- ppool(orip)
pvalue <- pvobj@pvalue
padjust <- pvobj@adjp
}
\references{
Benjamini, Y. and Y. Hochberg (1995). "Controlling the false discovery rate: a practical and powerful approach to multiple testing." Journal of the Royal Statistical Society. Series B (Methodological): 289-300.

Chang, L.-C., et al. (2013). "Meta-analysis methods for combining multiple expression profiles: comparisons, statistical characterization and an application guideline." BMC bioinformatics 14(1): 368.

Won, S., et al. (2009). "Choosing an optimal method to combine P-values." Statistics in medicine 28(11): 1537-1553.

Alves, G., & Yu, Y. K. (2014). Accuracy evaluation of the unified P-value from combining correlated P-values. PloS one, 9(3), e91225.
}
