% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testsim.R
\name{jumptestperiod}
\alias{jumptestperiod}
\title{Nonparametric jump test for a long period}
\usage{
jumptestperiod(retmat, method = "BNS")
}
\arguments{
\item{retmat}{log return matrix, with intervals saved in columns}

\item{method}{jump test methods, chosen from "BNS", "Amed", and "Amin"}
}
\value{
\item{stat}{test statistics}

\item{pvalue}{p-value}

\item{adjp}{adjusted p-values via 'BH' method}
}
\description{
perform nonparametric jump test for many intervals, and saved in vectors
}
\examples{
orip <- matrix(runif(3000),1000,3)
testres <- jumptestperiod(orip)
ts <- testres@stat
pv <- testres@pvalue
adjpv <- testres@adjp
}
\references{
Barndorff-Nielsen, O. E. and N. Shephard (2006). "Econometrics of testing for jumps in financial economics using bipower variation." Journal of financial Econometrics 4(1): 1-30.

Andersen, T. G., et al. (2012). "Jump-robust volatility estimation using nearest neighbor truncation." Journal of Econometrics 169(1): 75-93.

Dumitru, A.-M. and G. Urga (2012). "Identifying jumps in financial assets: a comparison between nonparametric jump tests." Journal of Business & Economic Statistics 30(2): 242-255.
}
