% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessing_mutating.R
\name{AccessMutate.JuliaProxy}
\alias{AccessMutate.JuliaProxy}
\alias{$.JuliaStructProxy}
\alias{$<-.JuliaStructProxy}
\alias{[.JuliaProxy}
\alias{[<-.JuliaProxy}
\alias{[.JuliaSimpleArrayProxy}
\alias{[[.JuliaArrayProxy}
\alias{[[<-.JuliaArrayProxy}
\alias{[[.JuliaStructProxy}
\alias{[[<-.JuliaStructProxy}
\alias{length.JuliaArrayProxy}
\alias{dim.JuliaArrayProxy}
\title{Access or mutate Julia objects via proxy objects}
\usage{
\method{$}{JuliaStructProxy}(x, name)

\method{$}{JuliaStructProxy}(x, name) <- value

\method{[}{JuliaProxy}(x, ...)

\method{[}{JuliaProxy}(x, i, j, k) <- value

\method{[}{JuliaSimpleArrayProxy}(x, ...)

\method{[[}{JuliaArrayProxy}(x, ...)

\method{[[}{JuliaArrayProxy}(x, i, j, k) <- value

\method{[[}{JuliaStructProxy}(x, name)

\method{[[}{JuliaStructProxy}(x, name) <- value

\method{length}{JuliaArrayProxy}(x)

\method{dim}{JuliaArrayProxy}(x)
}
\arguments{
\item{x}{a Julia proxy object}

\item{name}{the field of a struct type, the name of a member in a \code{NamedTuple},
or a key in a Julia dictionary (type \code{AbstractDict})}

\item{value}{a suitable replacement value.
When replacing a range of elements in an array type, it is possible to
replace multiple elements with single elements. In all other cases,
the length of the replacement must match the number of elements to replace.}

\item{i, j, k, ...}{index(es) for specifying the elements to extract or replace}
}
\description{
Apply the R operators \code{$} and \code{$<-}, \code{[} and \code{[<-}, \code{[[}
and \code{[[<-} to access or modify parts of Julia objects via their proxy objects.
For an intuitive understanding, best see the examples below.
}
\details{
The operators \code{$} and \code{[[} allow to access properties of Julia \code{struct}s
and \code{NamedTuple}s via their proxy objects.
For dictionaries (Julia type \code{AbstractDict}), \code{$} and \code{[[}
can also be used to look up string keys.
Fields of \code{mutable struct}s and dictionary elements with string keys
can be set via \code{$<-} and \code{[[<-}.

For \code{AbstractArray}s, the \code{[}, \code{[<-}, \code{[[}, and \code{[[<-}
operators relay to the \code{getindex} and \code{setindex!} Julia functions.
The \code{[[} and \code{[[<-} operators are used to access or mutate a single element.
With \code{[} and \code{[<-}, a range of objects is accessed or mutated.
The elements of \code{Tuple}s can also be accessed via \code{[} and \code{[[}.

The dimensions of proxy objects for Julia \code{AbstractArray}s and \code{Tuple}s
can be queried via \code{length} and \code{dim}.
}
\examples{
if (juliaSetupOk()) {

   # (Mutable) struct
   juliaEval("mutable struct MyStruct
                x::Int
             end")

   MyStruct <- juliaFun("MyStruct")
   s <- MyStruct(1L)
   s$x
   s$x <- 2
   s[["x"]]

   # Array
   x <- juliaCall("map", MyStruct, c(1L, 2L, 3L))
   x
   length(x)
   x[[1]]
   x[[1]]$x
   x[[1]] <- MyStruct(2L)
   x[2:3]
   x[2:3] <- MyStruct(2L)
   x

   # Tuple
   x <- juliaEval("(1, 2, 3)")
   x[[1]]
   x[1:2]
   length(x)

   # NamedTuple
   x <- juliaEval("(a=1, b=2)")
   x$a

   # Dictionary
   strDict <- juliaEval('Dict("hi" => 1, "hello" => 2)')
   strDict
   strDict$hi
   strDict$hi <- 0
   strDict[["hi"]] <- 2
   strDict["howdy", "greetings"] <- c(2, 3)
   strDict["hi", "howdy"]

}

\dontshow{
rm(x, s, strDict)
JuliaConnectoR:::stopJulia()
}
}
