% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{julia_setup}
\alias{julia_setup}
\title{Do initial setup for the JuliaCall package.}
\usage{
julia_setup(JULIA_HOME = NULL, verbose = TRUE, install = TRUE,
  force = FALSE, useRCall = TRUE, rebuild = FALSE)
}
\arguments{
\item{JULIA_HOME}{the file folder which contains julia binary,
if not set, JuliaCall will look at the global option JULIA_HOME,
if the global option is not set,
JuliaCall will then look at the environmental variable JULIA_HOME,
if still not found, JuliaCall will try to use
the julia in path.}

\item{verbose}{whether to print out detailed information
about \code{julia_setup}.}

\item{install}{whether to execute installation script for dependent julia packages, whose default value is TRUE;
but can be set to FALSE to save startup time when no installation of dependent julia packages is needed.}

\item{force}{whether to force julia_setup to execute again.}

\item{useRCall}{whether or not you want to use RCall.jl in julia,
which is an amazing package to access R in julia.}

\item{rebuild}{whether to rebuild RCall.jl, whose default value is FALSE to save startup time.
If a new version of R is used, then this parameter needs to be set to TRUE.}
}
\value{
The julia interface, which is an environment with the necessary methods
  like command, source and things like that to communicate with julia.
}
\description{
\code{julia_setup} does the initial setup for the JuliaCall package.
    It setups automatic type conversion, Julia display systems, etc,
    and is necessary for every new R session to use the package.
    If not carried out manually, it will be invoked automatically before other julia_xxx functions.
}
\examples{

\donttest{ ## julia_setup is quite time consuming
  julia <- julia_setup()
}

}
