% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfunctions_summary.R
\name{rd_vcov}
\alias{rd_vcov}
\title{Extract the random effects variance covariance matrix
Returns the posterior mean of the variance-covariance matrix/matrices of
the random effects in a fitted JointAI object.}
\usage{
rd_vcov(object, outcome = NULL, start = NULL, end = NULL, thin = NULL,
  exclude_chains = NULL, mess = TRUE, warn = TRUE)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{outcome}{optional; vector of integers giving the indices of the
outcomes for which the random effects variance-covariance
matrix/matrices should be returned.}

\item{start}{the first iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (integer; see \code{\link[coda]{window.mcmc}}).
For example, \code{thin = 1} (default) will keep the MCMC samples
from all iterations; \code{thin = 5} would only keep every 5th
iteration.}

\item{exclude_chains}{optional vector of the index numbers of chains that
should be excluded}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}.}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}.}
}
\description{
Extract the random effects variance covariance matrix
Returns the posterior mean of the variance-covariance matrix/matrices of
the random effects in a fitted JointAI object.
}
