% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfunctions_vcov.R
\name{check_rd_vcov_list}
\alias{check_rd_vcov_list}
\title{First validation for rd_vcov}
\usage{
check_rd_vcov_list(rd_vcov, idvar)
}
\arguments{
\item{rd_vcov}{a character string or a list describing the the random effects
variance covariance structure (provided by the user)}

\item{idvar}{vector with the names of all grouping variables
(except "lvlone")}
}
\value{
A named list per grouping level where each elements contains
information on how the random effects variance-covariance matrices on
that level are structured.
Per level it can be either a character string (e.g. \code{"full"}) or a
list specifying structures per (groups) of
variable(s) (e.g. \code{list(full = c("a", "b"), indep = "c")})
}
\description{
Checks if \code{rd_vcov} is a \code{list} with elements for all grouping levels or does
not specify a grouping level.
If valid, this function also make sure that \code{rd_vcov} is a list per grouping
level by duplicating the contents if necessary.
}
\keyword{internal}
