% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.JointAI.R
\name{summary.JointAI}
\alias{summary.JointAI}
\alias{print.summary.JointAI}
\title{Summary of an object of class JointAI}
\usage{
\method{summary}{JointAI}(object, start = NULL, end = NULL, thin = NULL,
  quantiles = c(0.025, 0.975), subset = "main", ...)

\method{print}{summary.JointAI}(x, digits = max(3, .Options$digits - 3), ...)
}
\arguments{
\item{object}{object inheriting from class \code{JointAI}}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{quantiles}{posterior quantiles}

\item{subset}{subset of monitored parameters (columns in the MCMC sample).
Can be specified as a numeric vector of columns, a vector of
column names, as \code{subset = "main"} or \code{NULL}.
If \code{NULL}, all monitored nodes will be plotted.
\code{subset = "main"} (default) the main parameters of the
analysis model will be plotted (regression coefficients/fixed
effects, and, if available, standard deviation of the residual
and random effects covariance matrix).}

\item{...}{currently not used}

\item{x}{an object of class \code{summary.JointAI}}

\item{digits}{minimal number of \emph{significant} digits, see
    \code{\link{print.default}}.}
}
\description{
Summary of an object of class JointAI
}
\examples{
mod1 <- lm_imp(y~C1 + C2 + M2, data = wideDF, n.iter = 100)
summary(mod1)


}
\seealso{
The model fitting functions \code{\link{lm_imp}},
         \code{\link{glm_imp}}, \code{\link{lme_imp}}
}
