/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Debugger;

import java.util.Hashtable;
import java.util.Properties;

public class BugReportData {
    public static String[] propertyNames = new String[]{"java.vendor", "java.vm.info", "java.vm.name", "java.vm.version", "java.vm.compiler", "java.compiler", "java.version", "java.specification.version", "java.specification.name", "java.class.version", "os.arch", "os.name", "os.version", "java.class.path", "java.ext.dirs", "java.library.path"};
    public static String[] formNames = new String[]{"Omegahat version", "Operating System", "JDK Version", "Java Virtual Machine", "Java Compiler"};
    static int OMEGA_VERSION = 0;
    static int OS = 1;
    static int JDK_VERSION = 2;
    static int JVM_VERSION = 3;
    static int JAVA_COMPILER = 4;
    public static String[] values;

    public static void compute() {
        BugReportData.showSystem();
        values = new String[formNames.length];
        BugReportData.values[BugReportData.OMEGA_VERSION] = BugReportData.computeOmegaVersion();
        BugReportData.values[BugReportData.OS] = BugReportData.computeOS();
        BugReportData.values[BugReportData.JDK_VERSION] = BugReportData.computeJDKVersion();
        BugReportData.values[BugReportData.JVM_VERSION] = BugReportData.computeJVM();
        BugReportData.values[BugReportData.JAVA_COMPILER] = BugReportData.computeCompiler();
    }

    public static String computeCompiler() {
        String string = System.getProperty("java.class.path");
        if (string.indexOf("Environment.jar") > -1) {
            return "Binary Release";
        }
        String string2 = null;
        return string2;
    }

    public static String computeJDKVersion() {
        String string = System.getProperty("java.specification.version");
        if (string == null) {
            string = System.getProperty("java.version");
        }
        string = String.valueOf(string) + " [ class id " + System.getProperty("java.class.version") + "]";
        return string;
    }

    public static String computeJVM() {
        if (System.getProperty("java.vendor").indexOf("Transvirtual") > -1) {
            return "kaffe";
        }
        String string = "Other";
        String string2 = System.getProperty("java.vm.name");
        if (string2 == null) {
            string2 = System.getProperty("java.vendor");
            if (string2 != null && string2.indexOf("Sun") > -1) {
                string = "java";
            }
        } else if (string2.indexOf("Classic") > -1 || string2.indexOf("Solaris") > -1) {
            string = "java";
        }
        return string;
    }

    public static String computeOS() {
        return String.valueOf(System.getProperty("os.name")) + System.getProperty("os.version");
    }

    public static String computeOmegaVersion() {
        return "0.01";
    }

    public static void main(String[] stringArray) {
        BugReportData.show();
    }

    public static Hashtable show() {
        return BugReportData.show(System.getProperties());
    }

    public static Hashtable show(Properties properties) {
        Properties properties2 = new Properties();
        if (values == null) {
            BugReportData.compute();
        }
        int n = 0;
        while (n < formNames.length) {
            String string = values[n] == null ? "" : values[n];
            System.err.println(String.valueOf(formNames[n]) + ":  " + string);
            ((Hashtable)properties2).put(formNames[n], string);
            ++n;
        }
        return properties2;
    }

    public static void showSystem() {
        BugReportData.showSystem(System.getProperties());
    }

    public static void showSystem(Properties properties) {
        int n = 0;
        while (n < propertyNames.length) {
            String string = propertyNames[n];
            if (((Hashtable)properties).containsKey(string)) {
                String string2 = properties.getProperty(string);
                System.err.println(String.valueOf(string) + "  =  " + string2);
            } else {
                System.err.println("*** " + string);
            }
            ++n;
        }
    }
}

