/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Databases;

import org.omegahat.Environment.Databases.Database;
import org.omegahat.Environment.Databases.TypedDatabase;
import org.omegahat.Environment.Interpreter.EvaluationException;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Language.LazyArgument;
import org.omegahat.Environment.Language.LazyFunction;

public class LazyFunctionDatabase
extends TypedDatabase {
    public static boolean DefaultStripFlag = true;
    public static String LazyArgument = "Lazy Argument";
    protected Evaluator evaluator;
    protected LazyFunction function;

    public LazyFunctionDatabase() {
        super("Lazy Function DB");
    }

    public LazyFunctionDatabase(String string) {
        super(string);
    }

    public LazyFunctionDatabase(LazyFunction lazyFunction) {
        this();
        this.Function(lazyFunction);
    }

    public LazyFunctionDatabase(LazyFunction lazyFunction, Evaluator evaluator) {
        this();
        this.Function(lazyFunction);
        this.evaluator(evaluator);
    }

    public LazyFunction Function() {
        return this.function;
    }

    public LazyFunction Function(LazyFunction lazyFunction) {
        this.function = lazyFunction;
        return this.Function();
    }

    public boolean assign(String string, Object object) throws Exception {
        boolean bl = super.assign(string, object);
        if (!bl && object instanceof LazyArgument) {
            Class clazz = this.type(string);
            if (clazz != null) {
                this.setType(string, object.getClass());
            }
            bl = super.assign(string, object);
            if (clazz != null) {
                this.setType(string, clazz);
            }
        }
        return bl;
    }

    public Evaluator evaluator() {
        return this.evaluator;
    }

    public Evaluator evaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
        return this.evaluator();
    }

    public Object get(String string) {
        return this.get(string, this.evaluator());
    }

    public Object get(String string, Evaluator evaluator) {
        Object object = super.get(string);
        if (object instanceof LazyArgument) {
            try {
                object = ((LazyArgument)object).eval(evaluator);
            }
            catch (Throwable throwable) {
                throw new EvaluationException("Error in evaluating lazy argument " + string, throwable, ((LazyArgument)object).expression(), evaluator);
            }
        }
        return object;
    }

    public Object get(String string, boolean bl) throws Throwable {
        return this.get(string, bl, DefaultStripFlag);
    }

    public Object get(String string, boolean bl, boolean bl2) throws Throwable {
        if (bl) {
            return this.get(string);
        }
        LazyArgument lazyArgument = (LazyArgument)super.get(string);
        if (bl2) {
            return lazyArgument.expression();
        }
        return lazyArgument;
    }

    public boolean isLazy(String string) {
        return this.Function().isLazy(string);
    }

    public Database templateDB() {
        return this.Function().argList();
    }
}

