% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdt_simple.R
\name{mdt_simple}
\alias{mdt_simple}
\title{Joint-significance test for simple mediation}
\usage{
mdt_simple(data, IV, DV, M)
}
\arguments{
\item{data}{A data frame containing the variables to be used in the model.}

\item{IV}{An unquoted numeric variable in the data frame which will be used
as independent variable.}

\item{DV}{An unquoted numeric variable in the data frame which will be used
as dependent variable.}

\item{M}{An unquoted numeric variable in the data frame which will be used as
mediator.}
}
\value{
Returns an object of class "\code{mediation_model}".

An object of class "\code{mediation_model}" is a list containing at least
the components:

\item{type}{A character string containing the type of model that has been
conducted (e.g., \code{"simple mediation"}).}
\item{method}{A character string containing the approach that has been
used to conduct the mediation analysis (usually
\code{"joint significance"}).} \item{params}{A named list of character
strings describing the variables used in the model.}
\item{paths}{A named list containing information on each relevant path of
the mediation model.}
\item{indirect_index}{A boolean indicating whether an indirect effect index
has been computed or not. Defaults to \code{FALSE}. See
\code{\link{add_index}} to compute mediation index.}
\item{indirect_index_infos}{(Optional) An object of class
\code{"indirect_index"}. Appears when one applies \code{\link{add_index}}
to an object of class \code{"mediation_model"}.}
\item{js_models}{A list of objects of class \code{"lm"}. Contains every
model relevant to joint-significance testing.}
\item{data}{The original data frame that has been passed through
\code{data} argument.}
}
\description{
Given a data frame, a predictor (\code{IV}), an outcome
(\code{DV}), and a mediator (\code{M}), conducts a joint-significant test
for simple mediation (see Yzerbyt, Muller, Batailler, & Judd, 2018).
}
\details{
With simple mediation analysis, one is interested in finding if the
effect of \eqn{X} on \eqn{Y} goes through a third variable \eqn{M}. The
hypothesis behind this test is that \eqn{X} has an effect on \eqn{M}
(\eqn{a}) that has an effect on \eqn{Y} (\eqn{b}), meaning that \eqn{X}
has an indirect effect on \eqn{Y} through \eqn{M}.

The total effect of \eqn{X} on \eqn{Y} can be described as follows:

\deqn{c = c' + ab}

with \eqn{c} the total effect of \eqn{X} on \eqn{Y}, \eqn{c'} the direct of
\eqn{X} on \eqn{Y}, and \eqn{ab} the indirect effect of \eqn{X} on \eqn{Y}
through \eqn{M} (see Models section).

To assess whether the indirect effect is different from the null, one has
to assess the significance against the null for both \eqn{a} (the effect of
\eqn{X} on \eqn{M}) and \eqn{b} (effect of \eqn{M} on \eqn{Y}
controlling for the effect of \eqn{X}). Both \eqn{a} and \eqn{b} need to
be simultaneously significant for an indirect effect to be claimed (Cohen &
Cohen, 1983; Yzerbyt, Muller, Batailler, & Judd, 2018).
}
\section{Models}{
 In a simple mediation model, three models will be fitted:
\itemize{
\item \eqn{Y_i = b_{10} + \mathbf{c_{11}} X_i}{Yi = b_10 + c_11*Xi}
\item \eqn{M_i = b_{20} + \mathbf{a_{21}} X_i}{Mi = b_20 + a_21*Xi}
\item \eqn{Y_i = b_{30} + \mathbf{c'_{31}} X_i + \mathbf{b_{32}} M_i}{Yi =
    b_30 + c'_31*Xi + b_32*Mi}
}

with \eqn{Y_i}{Yi}, the outcome value for the \emph{i}th observation,
\eqn{X_i}{Xi}, the predictor value for the \emph{i}th observation, and
\eqn{M_i}{Mi}, the mediator value for the \emph{i}th observation (Cohen &
Cohen, 1983; Yzerbyt, Muller, Batailler, & Judd, 2018).

Coefficients associated with \eqn{a}, \eqn{b}, \eqn{c}, and \eqn{c'} paths
are respectively \eqn{a_{21}}{a_21}, \eqn{b_{32}}{b_32},
\eqn{c_{11}}{c_11}, and \eqn{c'_{31}}{c'_31}.
}

\section{Variable coding}{
 Because joint-significance tests uses linear models
behind the scenes, variables involved in the model have to be numeric.
\code{mdt_simple} will give an error if non-numeric variables are
specified in the model.

To convert a dichotomous categorical variable to a numeric one, please
refer to the \code{\link{build_contrast}} function.
}

\examples{
## fit a simple mediation model
data(ho_et_al)
ho_et_al$condition_c <- build_contrast(ho_et_al$condition,
                                       "Low discrimination",
                                       "High discrimination")
mdt_simple(data = ho_et_al,
           IV = condition_c,
           DV = hypodescent,
           M = linkedfate)

}
\references{
Cohen, J., & Cohen, P. (1983). \emph{Applied multiple
regression/correlation analysis for the behavioral sciences} (2nd ed).
Hillsdale, N.J: L. Erlbaum Associates.

Yzerbyt, V., Muller, D., Batailler, C., & Judd, C. M. (2018). New
recommendations for testing indirect effects in mediational models: The
need to report and test component paths. \emph{Journal of Personality and
Social Psychology}, \emph{115}(6), 929–943. doi: 10.1037/pspa0000132
}
\seealso{
Other mediation models: 
\code{\link{mdt_moderated}()},
\code{\link{mdt_within}()}
}
\concept{mediation models}
