% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_psvcsignal.R
\name{plot.psvcsignal}
\alias{plot.psvcsignal}
\title{Plotting function for \code{psVCSignal}}
\usage{
\method{plot}{psvcsignal}(x, ..., xlab = " ", ylab = " ", Resol = 100)
}
\arguments{
\item{x}{the P-spline object, usually from \code{psVCSignal}.}

\item{...}{other parameters.}

\item{xlab}{label for the x-axis, e.g. "my x" (quotes required).}

\item{ylab}{label for the y-axis, e.g. "my y" (quotes required).}

\item{Resol}{resolution for plotting, default \code{Resol = 100}.}
}
\value{
\item{Plot}{a two panel plot, one of the 2D P-spline signal coefficient surface
and another that displays several slices of the smooth coefficient vectors at fixed levels of the
varying index.}
}
\description{
Plotting function for varying-coefficent signal
regression P-spline smooth coefficients (using \code{psVCSignal} with \code{class psvcsignal}).
Although se surface bands can be comuputed they are intentially left out as they are not
interpretable, and there is generally little data to steer
such a high-dimensional parameterization.
}
\examples{
library(fds)
data(nirc)
iindex <- nirc$x
X <- nirc$y
sel <- 50:650 # 1200 <= x & x<= 2400
X <- X[sel, ]
iindex <- iindex[sel]
dX <- diff(X)
diindex <- iindex[-1]
y <- as.vector(labc[1, 1:40]) # percent fat
t_var <- as.vector(labc[4, 1:40]) # percent flour
oout <- 23
dX <- t(dX[, -oout])
y <- y[-oout]
t_var = t_var[-oout]
Pars = rbind(c(min(diindex), max(diindex), 25, 3, 1e-7, 2),
c(min(t_var), max(t_var), 20, 3, 0.0001, 2))
fit1 <- psVCSignal(y, dX, diindex, t_var, Pars = Pars,
family = "gaussian", link = "identity", int = TRUE)
plot(fit1, xlab = "Coefficient Index", ylab = "VC: \% Flour")
names(fit1)
}
\references{
Eilers, P. H. C. and Marx, B. D. (2003). Multivariate calibration with temperature
interaction using two-dimensional penalized signal regression. \emph{Chemometrics
and Intellegent Laboratory Systems}, 66, 159–174.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers and Brian Marx
}
