/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.util.HashMap;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.JGR.browser.BrowserNodeFactory;
import org.rosuda.JGR.browser.DataFrameNode;
import org.rosuda.JGR.browser.DefaultBrowserNode;
import org.rosuda.JGR.browser.EnvironmentNode;
import org.rosuda.JGR.browser.FactorNode;
import org.rosuda.JGR.browser.FunctionNode;
import org.rosuda.JGR.browser.LmNode;
import org.rosuda.JGR.browser.MatrixNode;
import org.rosuda.JGR.browser.NumericNode;

public class BrowserController {
    public static int MAX_CHILDREN = 10000;
    protected static boolean initialized = false;
    protected static HashMap factories = new HashMap();
    protected static BrowserNodeFactory defaultFactory = new DefaultBrowserNode();

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            BrowserController.setFactory("numeric", new NumericNode());
            BrowserController.setFactory("integer", new NumericNode());
            BrowserController.setFactory("factor", new FactorNode());
            BrowserController.setFactory("character", new FactorNode());
            BrowserController.setFactory("logical", new FactorNode());
            BrowserController.setFactory("data.frame", new DataFrameNode());
            BrowserController.setFactory("matrix", new MatrixNode());
            BrowserController.setFactory("environment", new EnvironmentNode());
            BrowserController.setFactory("function", new FunctionNode());
            BrowserController.setFactory("lm", new LmNode());
            BrowserController.setFactory("glm", new LmNode());
        }
    }

    public static BrowserNode createNode(BrowserNode browserNode, String string, String string2) {
        BrowserController.initialize();
        BrowserNodeFactory browserNodeFactory = (BrowserNodeFactory)factories.get(string2);
        if (browserNodeFactory == null) {
            return defaultFactory.generate(browserNode, string, string2);
        }
        return browserNodeFactory.generate(browserNode, string, string2);
    }

    public static void setFactory(String string, BrowserNodeFactory browserNodeFactory) {
        BrowserController.initialize();
        factories.put(string, browserNodeFactory);
    }

    public void setDefaultFactory(BrowserNodeFactory browserNodeFactory) {
        BrowserController.initialize();
        defaultFactory = browserNodeFactory;
    }
}

