/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import jedit.syntax.DefaultInputHandler;
import jedit.syntax.InputHandler;
import jedit.syntax.JEditTextArea;
import jedit.syntax.TextUtilities;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.editor.CodeCompletion;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;

public class RInputHandler
extends DefaultInputHandler {
    public static final ActionListener R_INSERT_TAB = new r_insert_tab();
    public static final ActionListener R_RUN_LINES = new r_run_lines();
    public static final ActionListener R_RUN_ALL = new r_run_all();
    public static final ActionListener R_COMMENT_LINES = new r_comment_lines();
    public static final ActionListener R_PREV_LINE = new r_prev_line(false);
    public static final ActionListener R_NEXT_LINE = new r_next_line(false);
    public static final ActionListener R_CLOSE_POPUPS = new r_close_popups();
    public static final ActionListener R_INSERT_BREAK = new r_insert_break();
    public static Popup codeCompletion;
    private String funHelp = null;
    private JToolTip Tip;
    private static Popup funHelpTip;

    public void addKeyBindings() {
        this.addDefaultKeyBindings();
        this.addKeyBinding("TAB", R_INSERT_TAB);
        this.addKeyBinding("M+ENTER", R_RUN_LINES);
        this.addKeyBinding("M+7", R_COMMENT_LINES);
        this.addKeyBinding("UP", R_PREV_LINE);
        this.addKeyBinding("DOWN", R_NEXT_LINE);
        this.addKeyBinding("ESCAPE", R_CLOSE_POPUPS);
        this.addKeyBinding("ENTER", R_INSERT_BREAK);
    }

    private String getLastCommand(KeyEvent keyEvent) {
        char c;
        int n;
        int n2;
        int n3;
        if (funHelpTip != null) {
            funHelpTip.hide();
        }
        JEditTextArea jEditTextArea = RInputHandler.getTextArea(keyEvent);
        int n4 = jEditTextArea.getCaretPosition();
        String string = jEditTextArea.getText();
        int n5 = jEditTextArea.getCaretPosition();
        int n6 = jEditTextArea.getText(0, n5 + 1).lastIndexOf(40);
        int n7 = jEditTextArea.getText(0, n5).lastIndexOf(41);
        if (n7 > n6) {
            return null;
        }
        if (n6 < 0) {
            return null;
        }
        if (n5 < 0) {
            return null;
        }
        try {
            n3 = jEditTextArea.getLineOfOffset(n5);
            n2 = jEditTextArea.getLineStartOffset(n3);
            n = jEditTextArea.getLineEndOffset(n3);
            if (n6 > n) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (string.substring(n2, n5).indexOf("#") >= 0) {
            return null;
        }
        int n8 = n6--;
        int n9 = n6;
        if (string == null) {
            return null;
        }
        for (n5 = n6; n8 > -1 && n5 > -1 && ((c = string.charAt(n5)) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c == '_'); --n8, --n5) {
        }
        n8 = n8 == -1 ? 0 : n8;
        try {
            n3 = jEditTextArea.getLineOfOffset(jEditTextArea.getCaretPosition());
            n2 = jEditTextArea.getLineStartOffset(n3);
            n = jEditTextArea.getLineEndOffset(n3);
            if (n8 < n2 || n9 > n) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (jEditTextArea.getCaretPosition() < n8) {
            return null;
        }
        return n8 != (n9 = ++n6) ? string.substring(n8, n9).trim() : null;
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n;
        String string;
        int n2;
        int n3;
        JEditTextArea jEditTextArea;
        if (funHelpTip != null) {
            funHelpTip.hide();
            funHelpTip = null;
        }
        if (JGRPrefs.useHelpAgentEditor) {
            try {
                jEditTextArea = RInputHandler.getTextArea(keyEvent);
                n3 = jEditTextArea.getCaretPosition();
                n2 = jEditTextArea.getLineOfOffset(jEditTextArea.getCaretPosition());
                if (n3 > 0 && jEditTextArea.getText(n3 - 1, 1).trim().length() != 0 && (string = this.getLastCommand(keyEvent)) != null) {
                    String string2 = string;
                    this.funHelp = RController.getFunHelpTip(string2);
                    if (string2 != null && this.funHelp != null) {
                        this.Tip = new JToolTip();
                        this.Tip.setTipText(this.funHelp);
                        this.Tip.addMouseListener(new MouseAdapter(){

                            public void mouseClicked(MouseEvent mouseEvent) {
                                if (funHelpTip != null) {
                                    funHelpTip.hide();
                                    funHelpTip = null;
                                }
                            }
                        });
                        n = jEditTextArea._offsetToX(n2, n3);
                        int n4 = jEditTextArea.lineToY(n2);
                        Point point = new Point(n, n4);
                        SwingUtilities.convertPointToScreen(point, (Component)keyEvent.getSource());
                        funHelpTip = PopupFactory.getSharedInstance().getPopup((Component)keyEvent.getSource(), this.Tip, point.x, point.y + 20);
                        funHelpTip.show();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (codeCompletion != null && keyEvent.getKeyCode() != 38 && keyEvent.getKeyCode() != 40) {
            jEditTextArea = RInputHandler.getTextArea(keyEvent);
            n3 = jEditTextArea.getCaretPosition();
            n2 = jEditTextArea.getCaretLine();
            string = jEditTextArea.getLineText(n2);
            int n5 = 0;
            n = n3;
            try {
                n5 = TextUtilities.findWordStart(string, n3 - jEditTextArea.getLineStartOffset(n2) - 1, ".");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            try {
                n = TextUtilities.findWordEnd(string, n3 - jEditTextArea.getLineStartOffset(n2) - 1, ".");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            String string3 = null;
            try {
                string3 = string.substring(n5, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            int n6 = -1;
            if (string3 == null || string3.trim().length() == 0 || (n6 = CodeCompletion.getInstance().updateList(string3)) < 1) {
                codeCompletion.hide();
                codeCompletion = null;
            }
        }
        super.keyReleased(keyEvent);
    }

    static {
        funHelpTip = null;
        actions.put("insert-tab", R_INSERT_TAB);
        actions.put("run-lines", R_RUN_LINES);
        actions.put("run-all", R_RUN_ALL);
        actions.put("comment-lines", R_COMMENT_LINES);
        actions.put("prev-line", R_PREV_LINE);
        actions.put("next-line", R_NEXT_LINE);
        actions.put("close-popups", R_CLOSE_POPUPS);
        actions.put("insert-break", R_INSERT_BREAK);
    }

    public static class r_insert_break
    extends InputHandler.insert_break {
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            if (!jEditTextArea.isEditable()) {
                jEditTextArea.getToolkit().beep();
                return;
            }
            if (codeCompletion != null) {
                String string = CodeCompletion.getInstance().getCompletion();
                jEditTextArea.setSelectedText(string);
                codeCompletion.hide();
                codeCompletion = null;
            } else if (funHelpTip != null) {
                funHelpTip.hide();
                funHelpTip = null;
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    public static class r_prev_line
    extends InputHandler.prev_line {
        public r_prev_line(boolean bl) {
            super(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (codeCompletion != null) {
                CodeCompletion.getInstance().previous();
            } else if (funHelpTip != null) {
                funHelpTip.hide();
                funHelpTip = null;
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    public static class r_next_line
    extends InputHandler.next_line {
        public r_next_line(boolean bl) {
            super(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (codeCompletion != null) {
                CodeCompletion.getInstance().next();
            } else if (funHelpTip != null) {
                funHelpTip.hide();
                funHelpTip = null;
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    public static class r_close_popups
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (codeCompletion != null) {
                codeCompletion.hide();
                codeCompletion = null;
            }
            if (funHelpTip != null) {
                funHelpTip.hide();
                funHelpTip = null;
            }
        }
    }

    public static class r_run_all
    extends InputHandler.insert_tab {
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            int n = 0;
            int n2 = jEditTextArea.getLineCount();
            for (int i = n; i < n2; ++i) {
                String string = jEditTextArea.getLineText(i).trim();
                if (string.length() <= 0) continue;
                System.out.println("run cmd: " + string);
            }
        }
    }

    public static class r_comment_lines
    extends InputHandler.insert_tab {
        public static final String COMMENT_CHAR = "#";

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            int n2 = jEditTextArea.getSelectionStartLine();
            int n3 = jEditTextArea.getSelectionEndLine();
            int n4 = jEditTextArea.getLineStartOffset(n3);
            if (n4 == (n = jEditTextArea.getSelectionEnd())) {
                --n3;
            }
            if (n2 < 0) {
                n2 = n3 = jEditTextArea.getCaretLine();
            }
            for (int i = n2; i <= n3; ++i) {
                int n5 = jEditTextArea.getLineStartOffset(i);
                try {
                    if (jEditTextArea.getLineText(i).trim().startsWith(COMMENT_CHAR)) {
                        jEditTextArea.getDocument().remove(n5, jEditTextArea.getLineText(i).indexOf(COMMENT_CHAR) + 1);
                        continue;
                    }
                    jEditTextArea.getDocument().insertString(n5, COMMENT_CHAR, null);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    new ErrorMsg(badLocationException);
                }
            }
        }
    }

    public static class r_run_lines
    extends InputHandler.insert_tab {
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            String string = jEditTextArea.getSelectedText().trim();
            if (string.length() > 0) {
                JGR.MAINRCONSOLE.execute(string.trim(), true);
            }
        }
    }

    public static class r_insert_tab
    extends InputHandler.insert_tab {
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea;
            int n;
            if (codeCompletion != null) {
                codeCompletion.hide();
                codeCompletion = null;
            }
            if ((n = (jEditTextArea = InputHandler.getTextArea(actionEvent)).getCaretPosition()) > 0 && jEditTextArea.getText(n - 1, 1).trim().length() != 0) {
                int n2 = jEditTextArea.getCaretLine();
                String string = jEditTextArea.getLineText(n2);
                int n3 = 0;
                int n4 = n;
                try {
                    n3 = TextUtilities.findWordStart(string, n - jEditTextArea.getLineStartOffset(n2) - 1, ".");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    n4 = TextUtilities.findWordEnd(string, n - jEditTextArea.getLineStartOffset(n2) - 1, ".");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                boolean bl = false;
                String string2 = "";
                try {
                    string2 = string.substring(n3, n4).trim();
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (string2.length() <= 0) {
                    super.actionPerformed(actionEvent);
                    return;
                }
                try {
                    bl = string.substring(n3 - 1, n3).equalsIgnoreCase("\"");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                int n5 = jEditTextArea._offsetToX(n2, n);
                int n6 = jEditTextArea.lineToY(n2);
                Point point = new Point(n5, n6);
                SwingUtilities.convertPointToScreen(point, (Component)actionEvent.getSource());
                int n7 = -1;
                n7 = bl ? CodeCompletion.getInstance().updateFileList(string2) : CodeCompletion.getInstance().updateList(string2);
                if (n7 > 0) {
                    codeCompletion = PopupFactory.getSharedInstance().getPopup((Component)actionEvent.getSource(), CodeCompletion.getInstance(), point.x, point.y + ((Component)actionEvent.getSource()).getFont().getSize() + 10);
                    codeCompletion.show();
                }
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }
}

