% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling_dataset_milestones.R
\name{format_milestone}
\alias{format_milestone}
\title{Format the milestone in a simpler format}
\usage{
format_milestone(raw_milestone, verbose = TRUE)
}
\arguments{
\item{raw_milestone}{Milestone. Subset of a \code{gh_response} object output
from the function \code{\link[gh]{gh}} which contains all the data and
metadata for a GitHub milestone.}

\item{verbose}{A logical value indicating whether to print additional
information. Default is \code{TRUE}.}
}
\value{
a data.frame with 3 entries:

\itemize{
\item Title: name of the milestone
\item description: Description of the milestone
\item due_on: date to with the issue is due
}
}
\description{
Format the milestone in a simpler format
}
\examples{

\donttest{
# With milestones
raw_milestones <- gh::gh(
    repo = "jdplus-main",
    owner = "jdemetra",
    endpoint = "/repos/:owner/:repo/milestones",
    state = "all",
    .limit = Inf
)
raw_milestone <- raw_milestones[[5L]]
format_milestone(raw_milestone)
}

}
\keyword{internal}
