% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radialplot.R
\name{radialplot}
\alias{radialplot}
\alias{radialplot.default}
\alias{radialplot.fissiontracks}
\alias{radialplot.UPb}
\alias{radialplot.PbPb}
\alias{radialplot.ArAr}
\alias{radialplot.KCa}
\alias{radialplot.ThPb}
\alias{radialplot.UThHe}
\alias{radialplot.ReOs}
\alias{radialplot.SmNd}
\alias{radialplot.RbSr}
\alias{radialplot.LuHf}
\alias{radialplot.ThU}
\title{Visualise heteroscedastic data on a radial plot}
\usage{
radialplot(x, ...)

\method{radialplot}{default}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  transformation = "log",
  sigdig = 2,
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  k = 0,
  np = 3,
  markers = NULL,
  oerr = 3,
  units = "",
  hide = NA,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{fissiontracks}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  transformation = "arcsin",
  sigdig = 2,
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  exterr = TRUE,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{UPb}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  transformation = "log",
  type = 4,
  cutoff.76 = 1100,
  cutoff.disc = discfilter(),
  show.numbers = FALSE,
  pch = 21,
  sigdig = 2,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  exterr = TRUE,
  common.Pb = 0,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{PbPb}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  sigdig = 2,
  transformation = "log",
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  exterr = TRUE,
  common.Pb = 2,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{ArAr}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  sigdig = 2,
  transformation = "log",
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  exterr = TRUE,
  i2i = FALSE,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{KCa}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  sigdig = 2,
  transformation = "log",
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  exterr = TRUE,
  i2i = FALSE,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{ThPb}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  sigdig = 2,
  transformation = "log",
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  exterr = TRUE,
  i2i = TRUE,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{UThHe}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  sigdig = 2,
  transformation = "log",
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{ReOs}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  sigdig = 2,
  transformation = "log",
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  exterr = TRUE,
  i2i = TRUE,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{SmNd}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  sigdig = 2,
  transformation = "log",
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  exterr = TRUE,
  i2i = TRUE,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{RbSr}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  sigdig = 2,
  transformation = "log",
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  exterr = TRUE,
  i2i = TRUE,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{LuHf}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  sigdig = 2,
  transformation = "log",
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  exterr = TRUE,
  i2i = TRUE,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)

\method{radialplot}{ThU}(
  x,
  from = NA,
  to = NA,
  z0 = NA,
  sigdig = 2,
  transformation = "log",
  show.numbers = FALSE,
  pch = 21,
  levels = NA,
  clabel = "",
  bg = c("yellow", "red"),
  col = "black",
  markers = NULL,
  k = 0,
  np = 3,
  Th0i = 0,
  oerr = 3,
  hide = NULL,
  omit = NULL,
  omit.col = NA,
  ...
)
}
\arguments{
\item{x}{Either an \code{[nx2]} matix of (transformed) values z
    and their standard errors s

OR

and object of class \code{fissiontracks}, \code{UThHe},
\code{ArAr}, \code{KCa}, \code{ReOs}, \code{SmNd}, \code{RbSr},
\code{LuHf}, \code{ThU}, \code{PbPb}, \code{ThPb} or \code{UPb}}

\item{...}{additional arguments to the generic \code{points}
function}

\item{from}{minimum age limit of the radial scale}

\item{to}{maximum age limit of the radial scale}

\item{z0}{central value}

\item{transformation}{one of either \code{log}, \code{linear},
\code{sqrt} or \code{arcsin} (if \code{x} has class
\code{fissiontracks} and \code{fissiontracks$format} \eqn{\neq
1}).}

\item{sigdig}{the number of significant digits of the numerical
values reported in the title of the graphical output.}

\item{show.numbers}{boolean flag (\code{TRUE} to show grain
numbers)}

\item{pch}{plot character (default is a filled circle)}

\item{levels}{a vector with additional values to be displayed as
different background colours of the plot symbols.}

\item{clabel}{label of the colour legend}

\item{bg}{Fill colour for the plot symbols. This can either be a
    single colour or multiple colours to form a colour ramp (to be
    used if \code{levels!=NA}):

a single colour: \code{rgb(0,1,0,0.5)}, \code{'#FF000080'},
\code{'white'}, etc.;

multiple colours: \code{c(rbg(1,0,0,0.5)},
\code{rgb(0,1,0,0.5))}, \code{c('#FF000080','#00FF0080')},
\code{c('blue','red')}, \code{c('blue','yellow','red')}, etc.;

a colour palette: \code{rainbow(n=100)},
\code{topo.colors(n=100,alpha=0.5)}, etc.; or

a reversed palette: \code{rev(topo.colors(n=100,alpha=0.5))}, etc.

for plot symbols, set \code{bg=NA}}

\item{col}{text colour to be used if \code{show.numbers=TRUE}}

\item{k}{number of peaks to fit using the finite mixture models of
Galbraith and Laslett (1993). Setting \code{k='auto'}
automatically selects an optimal number of components based on
the Bayes Information Criterion (BIC). Setting \code{k='min'}
estimates the minimum value using a three parameter model
consisting of a Normal distribution truncated by a discrete
component.}

\item{np}{number of parameters for the minimum age
model. Must be either 3 or 4.}

\item{markers}{vector of ages of radial marker lines to add to the
plot.}

\item{oerr}{indicates whether the analytical uncertainties of the
    output are reported in the plot title as:

\code{1}: 1\eqn{\sigma} absolute uncertainties.

\code{2}: 2\eqn{\sigma} absolute uncertainties.

\code{3}: absolute (1-\eqn{\alpha})\% confidence intervals, where
\eqn{\alpha} equales the value that is stored in
\code{settings('alpha')}.

\code{4}: 1\eqn{\sigma} relative uncertainties (\eqn{\%}).

\code{5}: 2\eqn{\sigma} relative uncertainties (\eqn{\%}).

\code{6}: relative (1-\eqn{\alpha})\% confidence intervals, where
\eqn{\alpha} equales the value that is stored in
\code{settings('alpha')}.}

\item{units}{measurement units to be displayed in the legend.}

\item{hide}{vector with indices of aliquots that should be removed
from the radial plot.}

\item{omit}{vector with indices of aliquots that should be plotted
but omitted from the central age calculation or mixture models.}

\item{omit.col}{colour that should be used for the omitted
aliquots.}

\item{exterr}{include the external sources of uncertainty into
the error propagation for the central age and mixture models?}

\item{type}{scalar indicating whether to plot the
\eqn{^{207}}Pb/\eqn{^{235}}U age (\code{type}=1), the
\eqn{^{206}}Pb/\eqn{^{238}}U age (\code{type}=2), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age (\code{type}=3), the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-\eqn{^{206}}Pb/\eqn{^{238}}U age
(\code{type}=4), the concordia age (\code{type}=5), or the
\eqn{^{208}}Pb/\eqn{^{232}}Th age (\code{type}=6).}

\item{cutoff.76}{the age (in Ma) below which the
\eqn{^{206}}Pb/\eqn{^{238}}U and above which the
\eqn{^{207}}Pb/\eqn{^{206}}Pb age is used. This parameter is
only used if \code{type=4}.}

\item{cutoff.disc}{discordance cutoff filter. This is an object of
class \code{\link{discfilter}}.}

\item{common.Pb}{common lead correction:

\code{0}: none

\code{1}: use the Pb-composition stored in

\code{settings('iratio','Pb207Pb206')} (if \code{x} has class
\code{UPb} and \code{x$format<4});

\code{settings('iratio','Pb206Pb204')} and
\code{settings('iratio','Pb207Pb204')} (if \code{x} has class
\code{PbPb} or \code{x} has class \code{UPb} and
\code{3<x$format<7}); or

\code{settings('iratio','Pb208Pb206')} and
\code{settings('iratio','Pb208Pb207')} (if \code{x} has class
\code{UPb} and \code{x$format=7} or \code{8}).

\code{2}: remove the common Pb by projecting the data along an
inverse isochron. Note: choosing this option introduces a degree of
circularity in the central age calculation. In this case the radial
plot just serves as a way to visualise the residuals of the data
around the isochron, and one should be careful not to
over-interpret the numerical output.

\code{3}: use the Stacey-Kramers two-stage model to infer the
initial Pb-composition}

\item{i2i}{`isochron to intercept': calculates the initial
(aka `inherited', `excess', or `common') \eqn{^{40}}Ar/\eqn{^{36}}Ar,
\eqn{^{40}}Ca/\eqn{^{44}}Ca, \eqn{^{207}}Pb/\eqn{^{204}}Pb,
\eqn{^{87}}Sr/\eqn{^{86}}Sr, \eqn{^{143}}Nd/\eqn{^{144}}Nd,
\eqn{^{187}}Os/\eqn{^{188}}Os, \eqn{^{230}}Th/\eqn{^{232}}Th,
\eqn{^{176}}Hf/\eqn{^{177}}Hf or \eqn{^{204}}Pb/\eqn{^{208}}Pb
ratio from an isochron fit. Setting \code{i2i} to \code{FALSE} uses
the default values stored in \code{settings('iratio',...)}.

Note that choosing this option introduces a degree of circularity
in the central age calculation. In this case the radial plot plot
just serves as a way to visualise the residuals of the data around
the isochron, and one should be careful not to over-interpret the
numerical output.}

\item{Th0i}{initial \eqn{^{230}}Th correction.

\code{0}: no correction

\code{1}: project the data along an isochron fit

\code{2}: if \code{x$format} is \code{1} or \code{2}, correct the
data using the measured present day \eqn{^{230}}Th/\eqn{^{238}}U,
\eqn{^{232}}Th/\eqn{^{238}}U and \eqn{^{234}}U/\eqn{^{238}}U
activity ratios in the detritus. If \code{x$format} is \code{3} or
\code{4}, correct the data using the measured
\eqn{^{238}}U/\eqn{^{232}}Th activity ratio of the whole rock, as
stored in \code{x} by the \code{read.data()} function.

\code{3}: correct the data using an assumed initial
\eqn{^{230}}Th/\eqn{^{232}}Th-ratio for the detritus (only relevant
if \code{x$format} is \code{1} or \code{2}).}
}
\value{
does not produce any numerical output, but does report the
    central age and the results of any mixture modelling in the
    title. An asterisk is added to the plot title if the initial
    daughter correction is based on an isochron regression, to
    highlight the circularity of using an isochron to compute a
    central age, and to indicate that the reported uncertainties do
    not include the uncertainty of the initial daughter correction.
    This is because this uncertainty is neither purely random nor
    purely systematic.
}
\description{
Implementation of a graphical device developed by Rex Galbraith to
display several estimates of the same quantity that have different
standard errors. Serves as a vehicle to display finite and continuous
mixture models.
}
\details{
The radial plot (Galbraith, 1988, 1990) is a graphical device that
was specifically designed to display heteroscedastic data, and is
constructed as follows.  Consider a set of dates
\eqn{\{t_1,...,t_i,...,t_n\}} and uncertainties
\eqn{\{s[t_1],...,s[t_i],...,s[t_n]\}}. Define \eqn{z_i = z[t_i]}
to be a transformation of \eqn{t_i} (e.g., \eqn{z_i = log[t_i]}),
and let \eqn{s[z_i]} be its propagated analytical uncertainty
(i.e., \eqn{s[z_i] = s[t_i]/t_i} in the case of a logarithmic
transformation). Create a scatter plot of \eqn{(x_i,y_i)} values,
where \eqn{x_i = 1/s[z_i]} and \eqn{y_i = (z_i-z_\circ)/s[z_i]},
where \eqn{z_\circ} is some reference value such as the mean. The
slope of a line connecting the origin of this scatter plot with any
of the \eqn{(x_i,y_i)}s is proportional to \eqn{z_i} and, hence,
the date \eqn{t_i}.

These dates can be more easily visualised by drawing a radial scale
at some convenient distance from the origin and annotating it with
labelled ticks at the appropriate angles. While the angular
position of each data point represents the date, its horizontal
distance from the origin is proportional to the
precision. Imprecise measurements plot on the left hand side of the
radial plot, whereas precise age determinations are found further
towards the right. Thus, radial plots allow the observer to assess
both the magnitude and the precision of quantitative data in one
glance.
}
\examples{
attach(examples)
radialplot(FT1)

dev.new()
radialplot(LudwigMixture,k='min')
}
\references{
Galbraith, R.F., 1988. Graphical display of estimates
    having differing standard errors. Technometrics, 30(3),
    pp.271-281.

Galbraith, R.F., 1990. The radial plot: graphical assessment of
spread in ages. International Journal of Radiation Applications and
Instrumentation. Part D. Nuclear Tracks and Radiation Measurements,
17(3), pp.207-214.

Galbraith, R.F. and Laslett, G.M., 1993. Statistical models for
mixed fission track ages. Nuclear Tracks and Radiation
Measurements, 21(4), pp.459-470.
}
\seealso{
\code{\link{peakfit}}, \code{\link{central}}
}
